/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.PathTokenizer;
import com.izforge.izpack.util.file.types.DataType;
import com.izforge.izpack.util.file.types.DirSet;
import com.izforge.izpack.util.file.types.FileList;
import com.izforge.izpack.util.file.types.FileSet;
import java.io.File;
import java.util.Vector;

public class Path
extends DataType
implements Cloneable {
    private static FileUtils fileUtils = FileUtils.getFileUtils();
    private Vector<Object> elements;

    public Path(AutomatedInstallData idata, String path) throws Exception {
        this.createPathElement().setPath(idata, path);
    }

    public Path() {
        this.elements = new Vector();
    }

    public void setLocation(File location) throws Exception {
        this.createPathElement().setLocation(location);
    }

    public void setPath(AutomatedInstallData idata, String path) throws Exception {
        this.createPathElement().setPath(idata, path);
    }

    public PathElement createPathElement() throws Exception {
        PathElement pe = new PathElement();
        this.elements.addElement(pe);
        return pe;
    }

    public void addFileset(FileSet fs) throws Exception {
        this.elements.addElement(fs);
        this.setChecked(false);
    }

    public void addFilelist(FileList fl) throws Exception {
        this.elements.addElement(fl);
        this.setChecked(false);
    }

    public void addDirset(DirSet dset) throws Exception {
        this.elements.addElement(dset);
        this.setChecked(false);
    }

    public void add(Path path) throws Exception {
        this.elements.addElement(path);
        this.setChecked(false);
    }

    public Path createPath() throws Exception {
        Path p = new Path();
        this.elements.addElement(p);
        this.setChecked(false);
        return p;
    }

    public void append(Path other) throws Exception {
        String[] pathElements;
        if (other == null) {
            return;
        }
        String[] stringArray = pathElements = other.list();
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElement = stringArray[n2];
            if (this.elements.indexOf(pathElement) == -1) {
                this.elements.addElement(pathElement);
            }
            ++n2;
        }
    }

    public void addExisting(Path source) throws Exception {
        this.addExisting(source, false);
    }

    public void addExisting(Path source, boolean tryUserDir) throws Exception {
        String[] pathElements = source.list();
        File userDir = tryUserDir ? new File(System.getProperty("user.dir")) : null;
        String[] stringArray = pathElements;
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElement = stringArray[n2];
            File f = null;
            f = new File(pathElement);
            if (tryUserDir && !f.exists()) {
                f = new File(userDir, pathElement);
            }
            if (f.exists()) {
                this.setLocation(f);
            } else {
                Debug.log("dropping " + f + " from path as it doesn't exist");
            }
            ++n2;
        }
    }

    public String[] list() throws Exception {
        Vector<String> result = new Vector<String>(2 * this.elements.size());
        int i = 0;
        while (i < this.elements.size()) {
            int n;
            Object o = this.elements.elementAt(i);
            if (o instanceof String) {
                Path.addUnlessPresent(result, (String)o);
            } else if (o instanceof PathElement) {
                String[] parts = ((PathElement)o).getParts();
                if (parts == null) {
                    throw new Exception("You must either set location or path on <pathelement>");
                }
                String[] stringArray = parts;
                n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    Path.addUnlessPresent(result, part);
                    ++n2;
                }
            } else if (o instanceof Path) {
                String[] parts;
                Path p = (Path)o;
                String[] stringArray = parts = p.list();
                int n3 = parts.length;
                n = 0;
                while (n < n3) {
                    String part = stringArray[n];
                    Path.addUnlessPresent(result, part);
                    ++n;
                }
            } else if (o instanceof DirSet) {
                DirSet dset = (DirSet)o;
                Path.addUnlessPresent(result, dset.getDir(), dset.getDirectoryScanner().getIncludedDirectories());
            } else if (o instanceof FileSet) {
                FileSet fs = (FileSet)o;
                Path.addUnlessPresent(result, fs.getDir(), fs.getDirectoryScanner().getIncludedFiles());
            } else if (o instanceof FileList) {
                FileList fl = (FileList)o;
                Path.addUnlessPresent(result, fl.getDir(), fl.getFiles());
            }
            ++i;
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        String[] list;
        block4: {
            list = this.list();
            if (list.length != 0) break block4;
            return "";
        }
        try {
            StringBuffer result = new StringBuffer(list[0].toString());
            int i = 1;
            while (i < list.length) {
                result.append(File.pathSeparatorChar);
                result.append(list[i]);
                ++i;
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] translatePath(AutomatedInstallData idata, String source) {
        Vector<String> result = new Vector<String>();
        if (source == null) {
            return new String[0];
        }
        PathTokenizer tok = new PathTokenizer(source);
        StringBuffer element = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String pathElement = tok.nextToken();
            try {
                element.append(Path.resolveFile(idata, pathElement));
            }
            catch (Exception e) {
                Debug.log("Dropping path element " + pathElement + " as it is not valid relative to the project");
            }
            int i = 0;
            while (i < element.length()) {
                Path.translateFileSep(element, i);
                ++i;
            }
            result.addElement(element.toString());
            element = new StringBuffer();
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public static String translateFile(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(source);
        int i = 0;
        while (i < result.length()) {
            Path.translateFileSep(result, i);
            ++i;
        }
        return result.toString();
    }

    protected static boolean translateFileSep(StringBuffer buffer, int pos) {
        if (buffer.charAt(pos) == '/' || buffer.charAt(pos) == '\\') {
            buffer.setCharAt(pos, File.separatorChar);
            return true;
        }
        return false;
    }

    public int size() throws Exception {
        return this.list().length;
    }

    public Object clone() {
        try {
            Path p = (Path)super.clone();
            p.elements = (Vector)this.elements.clone();
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static String resolveFile(AutomatedInstallData idata, String relativeName) throws Exception {
        File f = fileUtils.resolveFile(new File(idata.getInstallPath()), relativeName);
        return f.getAbsolutePath();
    }

    private static void addUnlessPresent(Vector<String> v, String s) {
        if (v.indexOf(s) == -1) {
            v.addElement(s);
        }
    }

    private static void addUnlessPresent(Vector<String> v, File dir, String[] s) {
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            File d = new File(dir, value);
            String absolutePath = d.getAbsolutePath();
            Path.addUnlessPresent(v, Path.translateFile(absolutePath));
            ++n2;
        }
    }

    public class PathElement {
        private String[] parts;

        public void setLocation(File loc) {
            this.parts = new String[]{Path.translateFile(loc.getAbsolutePath())};
        }

        public void setPath(AutomatedInstallData idata, String path) {
            this.parts = Path.translatePath(idata, path);
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

