/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import java.io.File;
import java.util.StringTokenizer;

public class DepthSelector
extends BaseExtendSelector {
    public int min = -1;
    public int max = -1;
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";

    public String toString() {
        StringBuffer buf = new StringBuffer("{depthselector min: ");
        buf.append(this.min);
        buf.append(" max: ");
        buf.append(this.max);
        buf.append("}");
        return buf.toString();
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                String paramname = parameter.getName();
                if (MIN_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setMin(Integer.parseInt(parameter.getValue()));
                    }
                    catch (NumberFormatException nfe1) {
                        this.setError("Invalid minimum value " + parameter.getValue());
                    }
                } else if (MAX_KEY.equalsIgnoreCase(paramname)) {
                    try {
                        this.setMax(Integer.parseInt(parameter.getValue()));
                    }
                    catch (NumberFormatException nfe1) {
                        this.setError("Invalid maximum value " + parameter.getValue());
                    }
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++n2;
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.min < 0 && this.max < 0) {
            this.setError("You must set at least one of the min or the max levels.");
        }
        if (this.max < this.min && this.max > -1) {
            this.setError("The maximum depth is lower than the minimum.");
        }
    }

    @Override
    public boolean isSelected(AutomatedInstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        int depth = -1;
        String absBase = basedir.getAbsolutePath();
        String absFile = file.getAbsolutePath();
        StringTokenizer tokBase = new StringTokenizer(absBase, File.separator);
        StringTokenizer tokFile = new StringTokenizer(absFile, File.separator);
        while (tokFile.hasMoreTokens()) {
            String filetoken = tokFile.nextToken();
            if (tokBase.hasMoreTokens()) {
                String basetoken = tokBase.nextToken();
                if (basetoken.equals(filetoken)) continue;
                throw new Exception("File " + filename + " does not appear within " + absBase + "directory");
            }
            if (this.max <= -1 || ++depth <= this.max) continue;
            return false;
        }
        if (tokBase.hasMoreTokens()) {
            throw new Exception("File " + filename + " is outside of " + absBase + "directory tree");
        }
        return this.min <= -1 || depth >= this.min;
    }
}

