/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.os.FileQueueOperation;
import com.izforge.izpack.util.os.SystemErrorException;
import com.izforge.izpack.util.os.WinSetupDefaultCallbackHandler;
import com.izforge.izpack.util.os.WinSetupFileQueue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class FileQueue {
    private Vector<FileQueueOperation> operations = new Vector();
    protected WinSetupFileQueue filequeue;

    public void add(FileQueueOperation op) {
        this.operations.addElement(op);
    }

    public void execute() throws Exception {
        WinSetupDefaultCallbackHandler handler = new WinSetupDefaultCallbackHandler();
        try {
            this.filequeue = new WinSetupFileQueue(handler);
        }
        catch (IOException ioe) {
            throw new IOException("Failed to open a file queue due to " + ioe.getMessage());
        }
        try {
            try {
                Enumeration<FileQueueOperation> ops = this.operations.elements();
                while (ops.hasMoreElements()) {
                    FileQueueOperation op = ops.nextElement();
                    op.addTo(this.filequeue);
                }
                this.filequeue.commit();
                List<SystemErrorException> exceptions = handler.getExceptions();
                if (exceptions != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("The following system errors occured during committing the file queue:\n");
                    for (SystemErrorException exception : exceptions) {
                        buf.append('\t');
                        buf.append(exception.toString());
                        buf.append('\n');
                    }
                    throw new IOException(buf.toString());
                }
            }
            catch (IOException ioe) {
                throw new IOException("File queue operation failed due to " + ioe.getMessage());
            }
        }
        finally {
            this.filequeue.close();
        }
    }

    public boolean isRebootNecessary() {
        if (this.filequeue != null) {
            return this.filequeue.isRebootNecessary();
        }
        return false;
    }
}

