/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import java.util.Enumeration;
import java.util.Vector;

public class RegexUtil {
    private static Vector<SelectNode> parseSelectString(String input) {
        Vector<SelectNode> nodes = new Vector<SelectNode>();
        StringBuffer buf = new StringBuffer();
        char[] c = input.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] == '\\') {
                if (buf.length() > 0) {
                    nodes.addElement(new StringSelectNode(buf.toString()));
                    buf.setLength(0);
                }
                while (i + 1 < c.length && Character.isDigit(c[i + 1])) {
                    buf.append(c[i + 1]);
                    ++i;
                }
                int groupNum = Integer.parseInt(buf.toString());
                buf.setLength(0);
                nodes.addElement(new GroupSelectNode(groupNum));
            } else {
                buf.append(c[i]);
            }
            ++i;
        }
        if (buf.length() > 0) {
            nodes.addElement(new StringSelectNode(buf.toString()));
            buf.setLength(0);
        }
        return nodes;
    }

    public static String select(String select, Vector<String> groups) {
        Vector<SelectNode> nodes = RegexUtil.parseSelectString(select);
        StringBuffer buf = new StringBuffer();
        Enumeration<SelectNode> e = nodes.elements();
        SelectNode node = null;
        while (e.hasMoreElements()) {
            node = e.nextElement();
            buf.append(node.select(groups));
        }
        return buf.toString();
    }

    public static boolean hasFlag(int options, int flag) {
        return (options & flag) > 0;
    }

    public static int removeFlag(int options, int flag) {
        return options & -1 - flag;
    }

    private static class GroupSelectNode
    implements SelectNode {
        private int groupNumber;

        public GroupSelectNode(int groupNumber) {
            this.groupNumber = groupNumber;
        }

        @Override
        public String select(Vector<String> groups) {
            if (this.groupNumber < groups.size()) {
                return groups.elementAt(this.groupNumber);
            }
            return "\\" + this.groupNumber;
        }

        public String toString() {
            return "group: " + this.groupNumber;
        }
    }

    private static interface SelectNode {
        public String select(Vector<String> var1);
    }

    private static class StringSelectNode
    implements SelectNode {
        private String text;

        public StringSelectNode(String text) {
            this.text = text;
        }

        @Override
        public String select(Vector<String> groups) {
            return this.text;
        }

        public String toString() {
            return "string: " + this.text;
        }
    }
}

