/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.unix.UnixHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class ShellScript {
    private static final String Author = "Author: marc.eppelmann_at_gmx.de";
    private static final String Generator = "Generator: " + ShellScript.class.getName();
    private static final String SCM_ID = "$Id$";
    private static final String Revision = "$Revision$";
    private static final String CommentPre = "# ";
    private static final String H = "# ";
    private static final String lf = "\n";
    private static final String lh = "\n# ";
    private static final String explanation = "\n# This is an automatically generated Script.\n# Usually this can be removed if the Generator \n# was unable to remove the script after execution.\n";
    private static String currentDateMsg = "Generated at: " + new Date().toString();
    private static final String header = "\n\n# This is an automatically generated Script.\n# Usually this can be removed if the Generator \n# was unable to remove the script after execution.\n\n# " + Generator + "\n" + "# " + "$Id$" + "\n" + "# " + "Author: marc.eppelmann_at_gmx.de" + "\n" + "# " + "$Revision$" + "\n" + "# " + currentDateMsg + "\n" + "\n";
    private StringBuffer content = new StringBuffer();
    private String itsLocation;
    private String itsShell;
    public static final String SH = "sh";
    public static final String BOURNE_SHELL = "sh";
    public static final String BASH = "bash";
    public static final String BOURNE_AGAIN_SHELL = "bash";

    public ShellScript(String aShell) {
        if (aShell != null) {
            this.setShell(aShell);
            this.content.append("#!/usr/bin/env ").append(this.getShell());
            this.content.append(header);
        }
    }

    public ShellScript() {
        this("sh");
    }

    public void setShell(String aShell) {
        this.itsShell = aShell;
    }

    public String getShell() {
        return this.itsShell;
    }

    public void append(Object anObject) {
        this.content.append(anObject);
    }

    public void append(char aChar) {
        this.content.append(aChar);
    }

    public void append(String[] anArray) {
        int i = 0;
        while (i < anArray.length) {
            String string = anArray[i];
            this.append(string);
            if (anArray.length > i) {
                this.append(' ');
            }
            ++i;
        }
    }

    public void appendln(String[] anArray) {
        int i = 0;
        while (i < anArray.length) {
            String string = anArray[i];
            this.append(string);
            if (anArray.length > i) {
                this.append(' ');
            }
            ++i;
        }
        this.appendln();
    }

    public void appendln(Object anObject) {
        this.append(anObject);
        this.append(lf);
    }

    public void appendln(char aChar) {
        this.append(aChar);
        this.append(lf);
    }

    public void appendln() {
        this.append(lf);
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public String getContentAsString() {
        return this.content.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append('\n');
        result.append(this.itsLocation);
        result.append('\n');
        result.append(this.content);
        return result.toString();
    }

    public void write(String aDestination) {
        this.itsLocation = aDestination;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(aDestination));
            writer.write(this.content.toString());
            writer.write(lh + aDestination + lf);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String exec(String itsParams) {
        FileExecutor.getExecOutput(new String[]{UnixHelper.getCustomCommand("chmod"), "+x", this.itsLocation});
        if (itsParams != null) {
            return FileExecutor.getExecOutput(new String[]{this.itsLocation, itsParams});
        }
        return FileExecutor.getExecOutput(new String[]{this.itsLocation});
    }

    public String exec() {
        return this.exec(null);
    }

    public static String execute(String aShell, StringBuffer lines, String aLocation, String itsParams) {
        ShellScript script = new ShellScript(aShell == null ? "sh" : aShell);
        script.append(lines);
        script.write(aLocation);
        return itsParams == null ? script.exec() : script.exec(itsParams);
    }

    public static String execute(StringBuffer lines, String aLocation) {
        return ShellScript.execute(null, lines, aLocation, null);
    }

    public static String execAndDelete(String aShell, StringBuffer lines, String aLocation, String itsParams) {
        String result = ShellScript.execute(aShell, lines, aLocation, itsParams);
        File location = new File(aLocation);
        try {
            location.delete();
        }
        catch (Exception e) {
            location.deleteOnExit();
        }
        return result;
    }

    public static String execAndDelete(StringBuffer lines, String aLocation) {
        return ShellScript.execAndDelete(null, lines, aLocation, null);
    }

    public static void main(String[] args) {
    }

    public void delete() {
        if (this.itsLocation != null) {
            File location = new File(this.itsLocation);
            try {
                location.delete();
            }
            catch (Exception e) {
                location.deleteOnExit();
            }
        }
    }
}

