/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.unix;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.unix.ShellScript;
import com.izforge.izpack.util.unix.UnixConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;

public class UnixHelper {
    public static String whichCommand = FileExecutor.getExecOutput(new String[]{"/usr/bin/env", "which", "which"}, false).trim();
    public static final String VERSION = "$Revision$";

    public static ArrayList<String> getEtcPasswdArray() {
        ArrayList<String> result = new ArrayList<String>();
        String line = "";
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(UnixConstants.etcPasswd));
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
            }
            catch (Exception exception) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static ArrayList<String> getYpPasswdArray() {
        ArrayList<String> result = new ArrayList<String>();
        String line = "";
        BufferedReader reader = null;
        String ypcommand = UnixHelper.getYpCatCommand();
        if (ypcommand != null && ypcommand.length() > 0) {
            try {
                try {
                    reader = new BufferedReader(new StringReader(FileExecutor.getExecOutput(new String[]{ypcommand, "passwd"})));
                    while ((line = reader.readLine()) != null) {
                        result.add(line);
                    }
                }
                catch (Exception exception) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static boolean kdeIsInstalled() {
        FileExecutor fileExecutor = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fileExecutor.executeCommand(new String[]{"/usr/bin/env", "kwin", "--version"}, execOut);
        return execResult == 0;
    }

    public static String getWhichCommand() {
        return whichCommand;
    }

    public static String getCpCommand() {
        return FileExecutor.getExecOutput(new String[]{UnixHelper.getWhichCommand(), "cp"}).trim();
    }

    public static String getSuCommand() {
        return FileExecutor.getExecOutput(new String[]{UnixHelper.getWhichCommand(), "su"}).trim();
    }

    public static String getRmCommand() {
        return FileExecutor.getExecOutput(new String[]{whichCommand, "rm"}).trim();
    }

    public static String getYpCatCommand() {
        return FileExecutor.getExecOutput(new String[]{whichCommand, "ypcat"}).trim();
    }

    public static String getCustomCommand(String aCommand) {
        return FileExecutor.getExecOutput(new String[]{whichCommand, aCommand}).trim();
    }

    public static void main(String[] args) {
        System.out.println("Hallo from " + UnixHelper.class.getName() + VERSION);
        System.out.println("WhichCommand: '" + UnixHelper.getWhichCommand() + "'");
        System.out.println("SuCommand: " + UnixHelper.getSuCommand());
        System.out.println("RmCommand: " + UnixHelper.getRmCommand());
        System.out.println("CopyCommand: " + UnixHelper.getCpCommand());
        System.out.println("YpCommand: " + UnixHelper.getYpCatCommand());
        System.out.println("CustomCommand: " + UnixHelper.getCustomCommand("cat"));
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UnixHelper.class.getName(), String.valueOf(Long.toString(System.currentTimeMillis())) + ".tmp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Tempfile: " + tempFile.toString());
        System.out.println("TempfileName: " + tempFile.getName());
        String username = System.getProperty("user.name");
        if ("root".equals(username)) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
                writer.write("Hallo");
                writer.flush();
                writer.close();
                if (tempFile.exists()) {
                    System.out.println("Wrote: " + tempFile + ">>Hallo");
                } else {
                    System.out.println("Could not Wrote: " + tempFile + "Hallo");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String destfilename = "/home/marc.eppelmann" + File.separator + "Desktop" + File.separator + tempFile.getName();
            System.out.println("Copy: " + tempFile.toString() + " to " + destfilename);
            ShellScript script = new ShellScript("bash");
            script.append(String.valueOf(UnixHelper.getSuCommand()) + " " + "marc.eppelmann" + " " + "-c" + " " + "\"" + UnixHelper.getCpCommand() + " " + tempFile.toString() + " " + destfilename + "\"");
            String shLocation = "/tmp/x.21.21";
            try {
                shLocation = File.createTempFile(UnixHelper.class.getName(), String.valueOf(Long.toString(System.currentTimeMillis())) + ".sh").toString();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            script.write(shLocation);
            script.exec();
        } else {
            System.out.println("Your name: '" + username + "' is not 'root'. But this is a test for the user root.");
        }
    }
}

