/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import ch.systemsx.cisd.common.concurrent.IActivityObserver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class FileCopyUtils {
    private static final int DEFAULT_BUFFER_SIZE = 16384;

    private FileCopyUtils() {
    }

    public static void copy(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            FileCopyUtils.copyDirectory(source, destination);
        } else {
            FileCopyUtils.copyFile(source, destination);
        }
    }

    public static void copy(File source, File destination, IActivityObserver observerOrNull) throws IOException {
        if (source.isDirectory()) {
            FileCopyUtils.copyDirectory(source, destination, observerOrNull);
        } else {
            FileCopyUtils.copyFile(source, destination, observerOrNull);
        }
    }

    public static void copyToDirectory(File source, File destDir) throws IOException {
        if (source.isDirectory()) {
            FileCopyUtils.copyDirectoryToDirectory(source, destDir);
        } else {
            FileCopyUtils.copyFileToDirectory(source, destDir);
        }
    }

    public static void copyToDirectory(File source, File destination, IActivityObserver observerOrNull) throws IOException {
        if (source.isDirectory()) {
            FileCopyUtils.copyDirectoryToDirectory(source, destination, observerOrNull);
        } else {
            FileCopyUtils.copyFileToDirectory(source, destination);
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {
        FileCopyUtils.copyFileToDirectory(srcFile, destDir, null);
    }

    public static void copyFileToDirectory(File srcFile, File destDir, IActivityObserver observerOrNull) throws IOException {
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileCopyUtils.copyFile(srcFile, new File(destDir, srcFile.getName()), observerOrNull);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileCopyUtils.copyFile(srcFile, destFile, null);
    }

    public static void copyFile(File srcFile, File destFile, IActivityObserver observerOrNull) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' exists but is a directory");
        }
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
        }
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + destFile + "' directory cannot be created");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException("Destination '" + destFile + "' exists but is read-only");
        }
        FileCopyUtils.doCopyFile(srcFile, destFile, observerOrNull);
    }

    private static void doCopyFile(File srcFile, File destFile, IActivityObserver observerOrNull) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream input = new FileInputStream(srcFile);
        try {
            FileOutputStream output = new FileOutputStream(destFile);
            try {
                FileCopyUtils.copy(input, output, observerOrNull);
                output.close();
                output = null;
            }
            finally {
                IOUtils.closeQuietly(output);
            }
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    private static long copy(InputStream input, OutputStream output, IActivityObserver observerOrNull) throws IOException {
        byte[] buffer = new byte[16384];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
            FileCopyUtils.update(observerOrNull);
        }
        return count;
    }

    private static void update(IActivityObserver observerOrNull) {
        if (observerOrNull != null) {
            observerOrNull.update();
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        FileCopyUtils.copyDirectoryToDirectory(srcDir, destDir, null);
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir, IActivityObserver observerOrNull) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (srcDir.exists() && !srcDir.isDirectory()) {
            throw new IllegalArgumentException("Source '" + destDir + "' is not a directory");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileCopyUtils.copyDirectory(srcDir, new File(destDir, srcDir.getName()), null, observerOrNull);
    }

    public static void copyDirectory(File srcDir, File destDir, IActivityObserver observerOrNull) throws IOException {
        FileCopyUtils.copyDirectory(srcDir, destDir, null, observerOrNull);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileCopyUtils.copyDirectory(srcDir, destDir, null);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        FileCopyUtils.copyDirectory(srcDir, destDir, filter, null);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter, IActivityObserver observerOrNull) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            File[] srcFiles;
            File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
            if (srcFiles != null && srcFiles.length > 0) {
                exclusionList = new ArrayList<String>(srcFiles.length);
                int i = 0;
                while (i < srcFiles.length) {
                    File copiedFile = new File(destDir, srcFiles[i].getName());
                    exclusionList.add(copiedFile.getCanonicalPath());
                    ++i;
                }
            }
        }
        FileCopyUtils.doCopyDirectory(srcDir, destDir, filter, exclusionList, observerOrNull);
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter, List<String> exclusionList, IActivityObserver observerOrNull) throws IOException {
        File[] files;
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else {
            if (!destDir.mkdirs()) {
                throw new IOException("Destination '" + destDir + "' directory cannot be created");
            }
            destDir.setLastModified(srcDir.lastModified());
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        File[] fileArray = files = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        if (files == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        int i = 0;
        while (i < files.length) {
            if (observerOrNull != null) {
                observerOrNull.update();
            }
            File copiedFile = new File(destDir, files[i].getName());
            if (exclusionList == null || !exclusionList.contains(files[i].getCanonicalPath())) {
                if (files[i].isDirectory()) {
                    FileCopyUtils.doCopyDirectory(files[i], copiedFile, filter, exclusionList, observerOrNull);
                } else {
                    FileCopyUtils.doCopyFile(files[i], copiedFile, observerOrNull);
                }
            }
            ++i;
        }
        destDir.setLastModified(srcDir.lastModified());
    }
}

