/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IToStringConverter;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public final class LogMonitoringAppender
extends AppenderSkeleton {
    private static Map<LogMonitoringAppender, String> appenderMap = new HashMap<LogMonitoringAppender, String>();
    private final StringBuilder eventRecorder = new StringBuilder();
    private final Set<PatternCounter> patternCounters;

    private LogMonitoringAppender(Pattern ... patterns) {
        this.patternCounters = LogMonitoringAppender.createPatternCounters(patterns);
    }

    private static final Set<PatternCounter> createPatternCounters(Pattern[] patterns) {
        HashSet<PatternCounter> patternCounters = new HashSet<PatternCounter>(patterns.length);
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            patternCounters.add(new PatternCounter(pattern));
            ++n2;
        }
        return patternCounters;
    }

    public static final synchronized LogMonitoringAppender addAppender(LogCategory category, String ... messageParts) {
        int len = messageParts.length;
        Pattern[] patterns = new Pattern[len];
        int i = 0;
        while (i < len) {
            patterns[i] = Pattern.compile(Pattern.quote(messageParts[i]));
            ++i;
        }
        return LogMonitoringAppender.addAppender(category, patterns);
    }

    public static final synchronized LogMonitoringAppender addAppender(LogCategory category, Pattern ... regex) {
        LogMonitoringAppender appender = new LogMonitoringAppender(regex);
        String loggerName = category.name();
        Logger.getLogger((String)loggerName).addAppender((Appender)appender);
        appenderMap.put(appender, loggerName);
        return appender;
    }

    public static final synchronized void removeAppender(LogMonitoringAppender appender) {
        String loggerName = appenderMap.get((Object)appender);
        if (loggerName != null) {
            Logger.getLogger((String)loggerName).removeAppender((Appender)appender);
            appenderMap.remove((Object)appender);
        }
    }

    private final String getThrowableStr(LoggingEvent event) {
        ThrowableInformation info = event.getThrowableInformation();
        if (info == null) {
            return "";
        }
        return StringUtils.join((Object[])info.getThrowableStrRep(), (String)"\n");
    }

    private final String describePatterns() {
        return CollectionUtils.abbreviate(this.patternCounters, -1, true, new IToStringConverter<PatternCounter>(){

            @Override
            public final String toString(PatternCounter value) {
                return value.pattern.pattern();
            }
        });
    }

    public final void verifyLogHasNotHappened() {
        boolean hasNotHappened = true;
        for (PatternCounter patternCounter : this.patternCounters) {
            hasNotHappened &= patternCounter.count == 0;
        }
        assert (hasNotHappened) : String.format("Regex '%s' has been unexpectedly found in log:\n%s", this.describePatterns(), this.eventRecorder);
    }

    public final void verifyLogHasHappened() {
        boolean hasHappened = true;
        for (PatternCounter patternCounter : this.patternCounters) {
            hasHappened &= patternCounter.count > 0;
        }
        assert (hasHappened) : String.format("Regex '%s' has been missed in log:\n%s", this.describePatterns(), this.eventRecorder);
    }

    public final void reset() {
        for (PatternCounter patternCounter : this.patternCounters) {
            patternCounter.count = 0;
        }
    }

    protected final void append(LoggingEvent event) {
        String eventMessage = event.getMessage().toString();
        this.eventRecorder.append("event message: ").append(eventMessage).append('\n');
        String throwableStr = this.getThrowableStr(event);
        if (throwableStr.length() > 0) {
            this.eventRecorder.append("event throwable: ").append(throwableStr).append('\n');
        }
        for (PatternCounter patternCounter : this.patternCounters) {
            Pattern pattern = patternCounter.pattern;
            int count = 0;
            if (pattern.matcher(eventMessage).find() || pattern.matcher(throwableStr).find()) {
                ++count;
            }
            patternCounter.count += count;
        }
    }

    public final void close() {
    }

    public final boolean requiresLayout() {
        return false;
    }

    private static final class PatternCounter {
        final Pattern pattern;
        int count;

        private PatternCounter(Pattern pattern) {
            this.pattern = pattern;
        }

        public final String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        }
    }
}

