/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DataSetExistenceChecker {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetExistenceChecker.class);
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataSetExistenceChecker.class);
    private final IDataSetDirectoryProvider dataSetDirectoryProvider;
    private final long waitingTime;
    private final int maxRetries;

    public DataSetExistenceChecker(IDataSetDirectoryProvider dataSetDirectoryProvider, Properties properties) {
        this(dataSetDirectoryProvider, TimingParameters.create(properties));
    }

    public DataSetExistenceChecker(IDataSetDirectoryProvider dataSetDirectoryProvider, TimingParameters timingParameters) {
        this(dataSetDirectoryProvider, timingParameters.getIntervalToWaitAfterFailureMillis(), timingParameters.getMaxRetriesOnFailure());
    }

    public DataSetExistenceChecker(IDataSetDirectoryProvider dataSetDirectoryProvider, long waitingTime, int maxRetries) {
        this.dataSetDirectoryProvider = dataSetDirectoryProvider;
        this.waitingTime = waitingTime;
        this.maxRetries = maxRetries;
    }

    public boolean dataSetExists(DeletedDataSet dataset) {
        return this.dataSetExists(dataset.getCode(), dataset.getShareIdOrNull(), dataset.getLocationOrNull());
    }

    public boolean dataSetExists(IDatasetLocation dataSetLocation) {
        String dataSetCode = dataSetLocation.getDataSetCode();
        String shareId = this.dataSetDirectoryProvider.getShareIdManager().getShareId(dataSetCode);
        return this.dataSetExists(dataSetCode, shareId, dataSetLocation.getDataSetLocation());
    }

    private boolean dataSetExists(String dataSetCode, String shareId, String location) {
        File share = this.dataSetDirectoryProvider.getDataSetDirectory(shareId, "");
        File dataSetDirectory = this.dataSetDirectoryProvider.getDataSetDirectory(shareId, location);
        if (share.exists()) {
            return this.dataSetExists(dataSetDirectory, dataSetCode);
        }
        int i = 0;
        while (i < this.maxRetries) {
            this.sleep();
            if (share.exists()) {
                return this.dataSetExists(dataSetDirectory, dataSetCode);
            }
            ++i;
        }
        notificationLog.error((Object)("Data set '" + dataSetCode + "' couldn't retrieved because share '" + share + "' doesn't exists after " + this.maxRetries + " retries (waiting " + this.waitingTime + " msec between retries)."));
        return false;
    }

    private boolean dataSetExists(File dataSetDirectory, String dataSetCode) {
        if (dataSetDirectory.exists()) {
            return true;
        }
        operationLog.warn((Object)("Data set '" + dataSetCode + "' no longer exists."));
        return false;
    }

    private void sleep() {
        try {
            Thread.sleep(this.waitingTime);
        }
        catch (InterruptedException interruptedException) {}
    }
}

