/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import java.util.Date;

public class SimpleDateRenderer {
    private static final String DATE_SEP = "-";
    private static final String TIME_SEP = ":";
    private static final int MINUTES_PER_HOUR = 60;

    public static final String renderDate(Date dateOrNull) {
        if (dateOrNull == null) {
            return "";
        }
        int year = dateOrNull.getYear() + 1900;
        int month = dateOrNull.getMonth() + 1;
        int day = dateOrNull.getDate();
        int hour = dateOrNull.getHours();
        int min = dateOrNull.getMinutes();
        int sec = dateOrNull.getSeconds();
        StringBuffer sb = new StringBuffer();
        sb.append(year);
        sb.append(DATE_SEP);
        SimpleDateRenderer.zeroPaddingNumber(sb, month);
        sb.append(DATE_SEP);
        SimpleDateRenderer.zeroPaddingNumber(sb, day);
        sb.append(" ");
        SimpleDateRenderer.zeroPaddingNumber(sb, hour);
        sb.append(TIME_SEP);
        SimpleDateRenderer.zeroPaddingNumber(sb, min);
        sb.append(TIME_SEP);
        SimpleDateRenderer.zeroPaddingNumber(sb, sec);
        sb.append(" ");
        SimpleDateRenderer.appendGMT(sb, dateOrNull.getTimezoneOffset());
        return sb.toString();
    }

    private static void zeroPaddingNumber(StringBuffer buf, int value) {
        buf.append(value < 10 ? "0" : "");
        buf.append(value);
    }

    private static void appendGMT(StringBuffer buf, int timezoneOffset) {
        int value = -timezoneOffset;
        if (value < 0) {
            buf.append("GMT-");
            value = -value;
        } else {
            buf.append("GMT+");
        }
        SimpleDateRenderer.zeroPaddingNumber(buf, value / 60);
        buf.append(':');
        SimpleDateRenderer.zeroPaddingNumber(buf, value % 60);
    }
}

