/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.serializer;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.common.api.server.json.common.JsonConstants;
import ch.systemsx.cisd.openbis.common.api.server.json.deserializer.JsonTypeAndClassSerializer;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.Collection;

public class JsonSerializerFactory
extends BeanSerializerFactory {
    public JsonSerializerFactory() {
        super(null);
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig config, ArrayType type, BeanDescription beanDesc, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        TypeSerializer newTypeSerializer = this.createContentTypeSerializer(config, (JavaType)type, null);
        ArrayType newType = type.withContentTypeHandler((Object)newTypeSerializer);
        return super.buildArraySerializer(config, newType, beanDesc, staticTyping, newTypeSerializer, elementValueSerializer);
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, BeanProperty property, boolean staticTyping, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        TypeSerializer newTypeSerializer = this.createContentTypeSerializer(config, (JavaType)type, property);
        CollectionType newType = type.withContentTypeHandler((Object)newTypeSerializer);
        return super.buildCollectionSerializer(config, newType, beanDesc, property, staticTyping, newTypeSerializer, elementValueSerializer);
    }

    protected JsonSerializer<?> buildMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, boolean staticTyping, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) throws JsonMappingException {
        TypeSerializer newTypeSerializer = this.createContentTypeSerializer(config, (JavaType)type, null);
        MapType newType = type.withContentTypeHandler((Object)newTypeSerializer);
        return super.buildMapSerializer(config, newType, beanDesc, staticTyping, keySerializer, newTypeSerializer, elementValueSerializer);
    }

    private TypeSerializer createContentTypeSerializer(SerializationConfig config, JavaType containerType, BeanProperty property) {
        JavaType contentType = containerType.getContentType();
        if (contentType == null || contentType.getRawClass() == null) {
            return null;
        }
        Class contentClass = contentType.getRawClass();
        if (contentClass.equals(Object.class) || contentClass.isAnnotationPresent(JsonObject.class)) {
            BeanDescription bean = config.introspectClassAnnotations(contentType.getRawClass());
            AnnotatedClass ac = bean.getClassInfo();
            AnnotationIntrospector ai = config.getAnnotationIntrospector();
            Collection subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, (MapperConfig)config, ai);
            TypeNameIdResolver resolver = TypeNameIdResolver.construct((MapperConfig)config, (JavaType)contentType, (Collection)subtypes, (boolean)true, (boolean)false);
            return new JsonTypeAndClassSerializer((TypeIdResolver)resolver, property, JsonConstants.getTypeField());
        }
        return null;
    }
}

