/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.RetryProxyFactory;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DssComponentFactory;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationChangingService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SpaceWithProjectsAndRoleAssignments;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenbisServiceFacade
implements IOpenbisServiceFacade {
    private final String sessionToken;
    private final IGeneralInformationService service;
    private final IGeneralInformationChangingService changingService;
    private final IDssComponent dssComponent;
    private final int minorVersionInformationService;
    private final int minorVersionChangingService;

    @Private
    public static IOpenbisServiceFacade tryCreate(final String username, final String password, final String openbisUrl, final long timeoutInMillis) {
        RetryCaller<IOpenbisServiceFacade, RuntimeException> caller = new RetryCaller<IOpenbisServiceFacade, RuntimeException>(){

            @Override
            protected IOpenbisServiceFacade call() {
                IGeneralInformationService service = OpenbisServiceFacade.createGeneralInformationService(openbisUrl, timeoutInMillis);
                IGeneralInformationChangingService changingService = OpenbisServiceFacade.createGeneralInformationChangingService(openbisUrl, timeoutInMillis);
                String token = service.tryToAuthenticateForAllServices(username, password);
                if (token == null) {
                    throw UserFailureException.fromTemplate("Failed to authenticate user '%s' against the openBIS at '%s'.", username, openbisUrl);
                }
                IDssComponent dssComponent = DssComponentFactory.tryCreate(token, openbisUrl, timeoutInMillis);
                OpenbisServiceFacade facade = new OpenbisServiceFacade(token, service, changingService, dssComponent);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IOpenbisServiceFacade)caller.callWithRetry();
    }

    @Private
    public static IOpenbisServiceFacade tryCreate(final String sessionToken, final String openbisUrl, final long timeoutInMillis) {
        RetryCaller<IOpenbisServiceFacade, RuntimeException> caller = new RetryCaller<IOpenbisServiceFacade, RuntimeException>(){

            @Override
            protected IOpenbisServiceFacade call() {
                IGeneralInformationService service = OpenbisServiceFacade.createGeneralInformationService(openbisUrl, timeoutInMillis);
                IGeneralInformationChangingService changingService = OpenbisServiceFacade.createGeneralInformationChangingService(openbisUrl, timeoutInMillis);
                IDssComponent dssComponent = DssComponentFactory.tryCreate(sessionToken, openbisUrl, timeoutInMillis);
                OpenbisServiceFacade facade = new OpenbisServiceFacade(sessionToken, service, changingService, dssComponent);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IOpenbisServiceFacade)caller.callWithRetry();
    }

    private static IGeneralInformationService createGeneralInformationService(String openbisUrl, long timeoutInMillis) {
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-v1");
        IGeneralInformationService service = generalInformationServiceFinder.createService(IGeneralInformationService.class, openbisUrl, timeoutInMillis);
        return service;
    }

    private static IGeneralInformationChangingService createGeneralInformationChangingService(String openbisUrl, long timeoutInMillis) {
        ServiceFinder generalInformationServiceFinder = new ServiceFinder("openbis", "/rmi-general-information-changing-v1");
        IGeneralInformationChangingService service = generalInformationServiceFinder.createService(IGeneralInformationChangingService.class, openbisUrl, timeoutInMillis);
        return service;
    }

    public OpenbisServiceFacade(String sessionToken, IGeneralInformationService service, IGeneralInformationChangingService changingService, IDssComponent dssComponent) {
        this.sessionToken = sessionToken;
        this.service = service;
        this.minorVersionInformationService = service.getMinorVersion();
        this.changingService = changingService;
        this.minorVersionChangingService = changingService.getMinorVersion();
        this.dssComponent = dssComponent;
    }

    @Override
    public List<Project> listProjects() {
        return this.service.listProjects(this.sessionToken);
    }

    @Override
    public List<SpaceWithProjectsAndRoleAssignments> getSpacesWithProjects() throws EnvironmentFailureException {
        return this.service.listSpacesWithProjectsAndRoleAssignments(this.sessionToken, null);
    }

    @Override
    public List<Experiment> getExperiments(List<String> experimentIdentifiers) throws EnvironmentFailureException {
        return this.service.listExperiments(this.sessionToken, experimentIdentifiers);
    }

    @Override
    public List<Experiment> listExperimentsForProjects(List<String> projectIdentifiers) throws EnvironmentFailureException {
        return this.service.listExperiments(this.sessionToken, this.getProjects(projectIdentifiers), null);
    }

    @Override
    public List<Experiment> listExperimentsHavingSamplesForProjects(List<String> projectIdentifiers) throws EnvironmentFailureException {
        return this.service.listExperimentsHavingSamples(this.sessionToken, this.getProjects(projectIdentifiers), null);
    }

    @Override
    public List<Experiment> listExperimentsHavingDataSetsForProjects(List<String> projectIdentifiers) throws EnvironmentFailureException {
        return this.service.listExperimentsHavingDataSets(this.sessionToken, this.getProjects(projectIdentifiers), null);
    }

    private List<Project> getProjects(List<String> projectIdentifiers) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (ProjectIdentifier identifier : this.parseProjectIdentifiers(projectIdentifiers)) {
            Project project = new Project(identifier.getSpaceCode(), identifier.getProjectCode());
            projects.add(project);
        }
        return projects;
    }

    @Override
    public List<Sample> getSamples(List<String> sampleIdentifiers) throws EnvironmentFailureException {
        return this.getSamples(sampleIdentifiers, null);
    }

    @Override
    public List<Sample> getSamples(final List<String> sampleIdentifiers, EnumSet<SampleFetchOption> fetchOptions) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ANY_CLAUSES);
        for (SampleIdentifier sampleIdentifier : this.parseSampleIdentifiers(sampleIdentifiers)) {
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, sampleIdentifier.getSampleCode()));
        }
        List<Sample> samples = this.service.searchForSamples(this.sessionToken, searchCriteria, fetchOptions);
        List<Sample> filteredSamples = CollectionUtils.filter(samples, new CollectionUtils.ICollectionFilter<Sample>(){

            @Override
            public boolean isPresent(Sample element) {
                String identifier = element.getIdentifier();
                return identifier != null && sampleIdentifiers.contains(identifier);
            }
        });
        return filteredSamples;
    }

    @Override
    public List<Sample> listSamplesForExperiments(List<String> experimentIdentifiers) throws EnvironmentFailureException {
        return this.listSamplesForExperiments(experimentIdentifiers, null);
    }

    @Override
    public List<Sample> listSamplesForExperiments(final List<String> experimentIdentifiers, EnumSet<SampleFetchOption> fetchOptions) {
        SearchCriteria searchCriteria = this.searchCriteriaForExperimentIdentifiers(experimentIdentifiers);
        List<Sample> samples = this.service.searchForSamples(this.sessionToken, searchCriteria, fetchOptions);
        List<Sample> filteredSamples = CollectionUtils.filter(samples, new CollectionUtils.ICollectionFilter<Sample>(){

            @Override
            public boolean isPresent(Sample element) {
                String identifier = element.getExperimentIdentifierOrNull();
                return identifier != null && experimentIdentifiers.contains(identifier);
            }
        });
        return filteredSamples;
    }

    @Override
    public List<Sample> listSamplesForExperimentAndSampleType(String experimentPermId, String sampleType) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ALL_CLAUSES);
        searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.TYPE, sampleType));
        SearchCriteria experimentCriteria = new SearchCriteria();
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PERM_ID, experimentPermId));
        searchCriteria.addSubCriteria(SearchSubCriteria.createExperimentCriteria(experimentCriteria));
        return this.service.searchForSamples(this.sessionToken, searchCriteria, null);
    }

    @Override
    public List<Sample> listSamplesOfSample(String samplePermId) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        SearchCriteria sampleCriteria = new SearchCriteria();
        sampleCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PERM_ID, samplePermId));
        List<Sample> sampleWithChildren = this.service.searchForSamples(this.sessionToken, sampleCriteria, EnumSet.of(SampleFetchOption.CHILDREN));
        if (!sampleWithChildren.isEmpty()) {
            samples.addAll(sampleWithChildren.get(0).getChildren());
        }
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.addSubCriteria(SearchSubCriteria.createSampleContainerCriteria(sampleCriteria));
        samples.addAll(this.service.searchForSamples(this.sessionToken, searchCriteria, null));
        return samples;
    }

    @Override
    public List<Sample> listSamplesForProjects(List<String> projectIdentifiers) {
        return this.listSamplesForProjects(projectIdentifiers, null);
    }

    @Override
    public List<Sample> listSamplesForProjects(List<String> projectIdentifiers, EnumSet<SampleFetchOption> fetchOptions) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ANY_CLAUSES);
        for (ProjectIdentifier projectIdentifier : this.parseProjectIdentifiers(projectIdentifiers)) {
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PROJECT, projectIdentifier.getProjectCode()));
        }
        List<Sample> samples = this.service.searchForSamples(this.sessionToken, searchCriteria, fetchOptions);
        return samples;
    }

    @Override
    public DataSet getDataSet(String dataSetCode) throws EnvironmentFailureException {
        List<DataSet> dataSets = this.getDataSets(Collections.singletonList(dataSetCode));
        return dataSets.size() > 0 ? dataSets.get(0) : null;
    }

    @Override
    public List<DataSet> getDataSets(List<String> dataSetCodes) throws EnvironmentFailureException {
        this.enforceNotEmpty("Dataset codes", dataSetCodes);
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ANY_CLAUSES);
        for (String dataSetCode : dataSetCodes) {
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, dataSetCode));
        }
        return this.convertDataSets(this.service.searchForDataSets(this.sessionToken, searchCriteria));
    }

    @Override
    public List<DataSet> listDataSetsForExperiments(final List<String> experimentIdentifiers) throws EnvironmentFailureException {
        SearchCriteria searchCriteria = this.searchCriteriaForExperimentIdentifiers(experimentIdentifiers);
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.service.searchForDataSets(this.sessionToken, searchCriteria);
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> filteredDataSets = CollectionUtils.filter(dataSets, new CollectionUtils.ICollectionFilter<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet>(){

            @Override
            public boolean isPresent(ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet) {
                String identifier = dataSet.getExperimentIdentifier();
                return identifier != null && experimentIdentifiers.contains(identifier);
            }
        });
        return this.convertDataSets(filteredDataSets);
    }

    @Override
    public List<DataSet> listDataSetsForExperiment(String experimentPermId) {
        SearchCriteria searchCriteria = new SearchCriteria();
        SearchCriteria experimentCriteria = new SearchCriteria();
        experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PERM_ID, experimentPermId));
        searchCriteria.addSubCriteria(SearchSubCriteria.createExperimentCriteria(experimentCriteria));
        return this.convertDataSets(this.service.searchForDataSets(this.sessionToken, searchCriteria));
    }

    @Override
    public List<DataSet> listDataSetsForSamples(final List<String> sampleIdentifiers) throws EnvironmentFailureException {
        SearchCriteria searchCriteria = this.searchCriteriaForSampleIdentifiers(sampleIdentifiers);
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> dataSets = this.service.searchForDataSets(this.sessionToken, searchCriteria);
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> filteredDataSets = CollectionUtils.filter(dataSets, new CollectionUtils.ICollectionFilter<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet>(){

            @Override
            public boolean isPresent(ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet) {
                String identifier = dataSet.getSampleIdentifierOrNull();
                return identifier != null && sampleIdentifiers.contains(identifier);
            }
        });
        return this.convertDataSets(filteredDataSets);
    }

    @Override
    public List<DataSet> listDataSetsForSample(String samplePermId) {
        SearchCriteria searchCriteria = new SearchCriteria();
        SearchCriteria sampleCriteria = new SearchCriteria();
        sampleCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.PERM_ID, samplePermId));
        searchCriteria.addSubCriteria(SearchSubCriteria.createSampleCriteria(sampleCriteria));
        return this.convertDataSets(this.service.searchForDataSets(this.sessionToken, searchCriteria));
    }

    @Override
    public List<DataSetType> listDataSetTypes() {
        return this.service.listDataSetTypes(this.sessionToken);
    }

    @Override
    public List<SampleType> listSampleTypes() {
        return this.service.listSampleTypes(this.sessionToken);
    }

    @Override
    public List<ExperimentType> listExperimentTypes() {
        return this.service.listExperimentTypes(this.sessionToken);
    }

    public IDataSetDss getDataSetDss(String code) throws EnvironmentFailureException {
        return RetryProxyFactory.createProxy(this.dssComponent.getDataSet(code));
    }

    @Override
    public DataSet putDataSet(NewDataSetDTO newDataset, File dataSetFile) throws EnvironmentFailureException {
        IDataSetDss dataSetDss = this.dssComponent.putDataSet(newDataset, dataSetFile);
        return new DataSet(this, this.dssComponent, null, dataSetDss);
    }

    @Override
    public List<ValidationError> validateDataSet(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        return this.dssComponent.validateDataSet(newDataset, dataSetFile);
    }

    @Override
    public Map<String, String> extractMetadata(NewDataSetDTO newDataset, File dataSetFile) throws IllegalStateException, EnvironmentFailureException {
        return this.dssComponent.extractMetadata(newDataset, dataSetFile);
    }

    @Override
    public void checkSession() throws InvalidSessionException {
        this.dssComponent.checkSession();
    }

    @Override
    public synchronized void logout() {
        this.service.logout(this.sessionToken);
    }

    private List<ProjectIdentifier> parseProjectIdentifiers(List<String> identifiers) {
        this.enforceNotEmpty("Project identifiers", identifiers);
        ArrayList<ProjectIdentifier> list = new ArrayList<ProjectIdentifier>();
        for (String identifier : identifiers) {
            ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(identifier).createIdentifier();
            list.add(projectIdentifier);
        }
        return list;
    }

    private List<ExperimentIdentifier> parseExperimentIdentifiers(List<String> identifiers) {
        this.enforceNotEmpty("Experiment identifiers", identifiers);
        return ExperimentIdentifierFactory.parse(identifiers);
    }

    private List<SampleIdentifier> parseSampleIdentifiers(List<String> identifiers) {
        this.enforceNotEmpty("Sample identifiers", identifiers);
        ArrayList<SampleIdentifier> list = new ArrayList<SampleIdentifier>();
        for (String identifier : identifiers) {
            SampleIdentifier sampleIdentifier = new SampleIdentifierFactory(identifier).createIdentifier();
            list.add(sampleIdentifier);
        }
        return list;
    }

    private SearchCriteria searchCriteriaForExperimentIdentifiers(List<String> experimentIdentifiers) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ANY_CLAUSES);
        for (ExperimentIdentifier experimentIdentifier : this.parseExperimentIdentifiers(experimentIdentifiers)) {
            SearchCriteria experimentCriteria = new SearchCriteria();
            experimentCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, experimentIdentifier.getExperimentCode()));
            searchCriteria.addSubCriteria(SearchSubCriteria.createExperimentCriteria(experimentCriteria));
        }
        return searchCriteria;
    }

    private SearchCriteria searchCriteriaForSampleIdentifiers(List<String> sampleIdentifiers) {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setOperator(SearchCriteria.SearchOperator.MATCH_ANY_CLAUSES);
        for (SampleIdentifier sampleIdentifier : this.parseSampleIdentifiers(sampleIdentifiers)) {
            SearchCriteria sampleCriteria = new SearchCriteria();
            sampleCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.CODE, sampleIdentifier.getSampleCode()));
            searchCriteria.addSubCriteria(SearchSubCriteria.createSampleCriteria(sampleCriteria));
        }
        return searchCriteria;
    }

    private void enforceNotEmpty(String parameterName, List<String> identifiers) {
        if (identifiers == null || identifiers.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(parameterName) + " must contain at least one element.");
        }
    }

    @Override
    public int getMinorVersionInformationService() {
        return this.minorVersionInformationService;
    }

    @Override
    public WebAppSettings getWebAppSettings(String webAppId) {
        if (this.minorVersionChangingService >= 2) {
            return this.changingService.getWebAppSettings(this.sessionToken, webAppId);
        }
        return new WebAppSettings(webAppId, new HashMap<String, String>());
    }

    @Override
    public void setWebAppSettings(WebAppSettings customDisplaySettings) {
        if (this.minorVersionChangingService >= 2) {
            this.changingService.setWebAppSettings(this.sessionToken, customDisplaySettings);
        }
    }

    @Override
    public List<Experiment> searchForExperiments(SearchCriteria searchCriteria) {
        return this.service.searchForExperiments(this.sessionToken, searchCriteria);
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria) {
        return this.service.searchForSamples(this.sessionToken, searchCriteria);
    }

    @Override
    public List<Sample> searchForSamples(SearchCriteria searchCriteria, EnumSet<SampleFetchOption> fetchOptions) {
        return this.service.searchForSamples(this.sessionToken, searchCriteria, fetchOptions);
    }

    @Override
    public List<DataSet> searchForDataSets(SearchCriteria searchCriteria) {
        return this.convertDataSets(this.service.searchForDataSets(this.sessionToken, searchCriteria));
    }

    @Override
    public List<DataSet> listDataSets(List<Sample> samples, EnumSet<DataSet.Connections> connectionsToGet) {
        return this.convertDataSets(this.service.listDataSets(this.sessionToken, samples, connectionsToGet));
    }

    private List<DataSet> convertDataSets(List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet> internalDataSets) {
        ArrayList<DataSet> convertedDataSets = new ArrayList<DataSet>(internalDataSets.size());
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet dataSet : internalDataSets) {
            DataSet converted = new DataSet(this, this.dssComponent, dataSet, null);
            convertedDataSets.add(converted);
        }
        return convertedDataSets;
    }

    @Override
    public void addAdHocVocabularyTerm(TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) {
        this.changingService.addUnofficialVocabularyTerm(this.sessionToken, vocabularyId, code, label, description, previousTermOrdinal);
    }

    @Override
    public void addAdHocVocabularyTerm(Long vocabularyId, NewVocabularyTerm term) {
        this.changingService.addUnofficialVocabularyTerm(this.sessionToken, vocabularyId, term);
    }

    @Override
    public HashMap<Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> getVocabularyTermsMap() {
        return this.service.getVocabularyTermsMap(this.sessionToken);
    }

    @Override
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary> listVocabularies() {
        return this.service.listVocabularies(this.sessionToken);
    }
}

