/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.EntityLinkElementTranslator;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityLinkElement;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IRowBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.util.IRowBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import java.util.Date;

public class SimpleTableModelBuilderAdaptor
implements ISimpleTableModelBuilderAdaptor {
    private final SimpleTableModelBuilder builder;
    private final IEntityInformationProvider entityInformationProvider;

    public static SimpleTableModelBuilderAdaptor create(IEntityInformationProvider entityInformationProvider) {
        return new SimpleTableModelBuilderAdaptor(new SimpleTableModelBuilder(true), entityInformationProvider);
    }

    private SimpleTableModelBuilderAdaptor(SimpleTableModelBuilder builder, IEntityInformationProvider entityInformationProvider) {
        this.builder = builder;
        this.entityInformationProvider = entityInformationProvider;
    }

    @Override
    public TableModel getTableModel() {
        return this.builder.getTableModel();
    }

    @Override
    public void addHeader(String title) {
        this.builder.addHeader(title);
    }

    @Override
    public void addHeader(String title, String code) {
        this.builder.addHeader(title, code);
    }

    @Override
    public void addHeader(String title, int defaultColumnWidth) {
        this.builder.addHeader(title, defaultColumnWidth);
    }

    @Override
    public IRowBuilderAdaptor addRow() {
        final IRowBuilder row = this.builder.addRow();
        return new IRowBuilderAdaptor(){

            @Override
            public void setCell(String headerTitle, String value) {
                row.setCell(headerTitle, value);
            }

            @Override
            public void setCell(String headerTitle, long value) {
                row.setCell(headerTitle, value);
            }

            @Override
            public void setCell(String headerTitle, double value) {
                row.setCell(headerTitle, value);
            }

            @Override
            public void setCell(String headerTitle, Date value) {
                row.setCell(headerTitle, value);
            }

            @Override
            public void setCell(String headerTitle, IEntityLinkElement value) {
                row.setCell(headerTitle, this.asTableCell(value, null));
            }

            @Override
            public void setCell(String headerTitle, IEntityLinkElement value, String linkText) {
                row.setCell(headerTitle, this.asTableCell(value, linkText));
            }

            private EntityTableCell asTableCell(IEntityLinkElement value, String linkTextOrNull) {
                EntityKind entityKind = EntityLinkElementTranslator.translate(value.getEntityLinkKind());
                String permId = value.getPermId();
                String identifierOrNull = SimpleTableModelBuilderAdaptor.this.tryExtractIdentifier(value);
                EntityTableCell result = new EntityTableCell(entityKind, permId, identifierOrNull);
                result.setLinkText(linkTextOrNull);
                return result;
            }
        };
    }

    @Override
    public void addFullHeader(String ... titles) {
        this.builder.addFullHeader(titles);
    }

    @Override
    public void addFullRow(String ... values) {
        this.builder.addFullRow(values);
    }

    private String tryExtractIdentifier(IEntityLinkElement entityLink) {
        return this.entityInformationProvider.getIdentifier(entityLink);
    }
}

