/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.parser;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.ExcelFileLoader;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.ParsingException;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public final class BisExcelFileLoader<T>
extends ExcelFileLoader<T> {
    private static final String MESSAGE_FORMAT = "A problem has occurred while parsing line %d of file '%s':\n  %s";
    private static final String ERROR_IN_FILE_MESSAGE_FORMAT = "A problem has occurred while parsing file '%s':\n  %s";
    private final boolean acceptEmptyFiles;

    public BisExcelFileLoader(IParserObjectFactoryFactory<T> factory, boolean acceptEmptyFiles) {
        super(factory);
        this.acceptEmptyFiles = acceptEmptyFiles;
    }

    private static final void translateParsingException(ParsingException parsingException, String sectionName) {
        RuntimeException causeException = parsingException.getCauseRuntimeException();
        String message = causeException == null ? parsingException.getMessage() : causeException.getMessage();
        throw UserFailureException.fromTemplate(MESSAGE_FORMAT, parsingException.getLineNumber(), sectionName, message);
    }

    private static final void translateParserException(ParserException ex, String sectionName) {
        String message = ex.getMessage();
        throw UserFailureException.fromTemplate(ERROR_IN_FILE_MESSAGE_FORMAT, sectionName, message);
    }

    public List<T> load(Sheet sheet, int begin, int end, String sectionName, Map<String, String> defaults) throws ParserException, ParsingException, IllegalArgumentException {
        assert (sheet != null) : "Excel Sheet cannot be null.";
        try {
            List list = super.load(sheet, begin, end, defaults);
            if (!this.acceptEmptyFiles && list.size() == 0) {
                throw new UserFailureException("Given file '" + sectionName + "' is empty or does not contain any meaningful information.");
            }
            return list;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UserFailureException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ParsingException e) {
            BisExcelFileLoader.translateParsingException(e, sectionName);
            return null;
        }
        catch (ParserException e) {
            BisExcelFileLoader.translateParserException(e, sectionName);
            return null;
        }
    }
}

