/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.string;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogUtils;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.common.string.ReflectingStringEscaperRestricted;
import ch.systemsx.cisd.common.string.ReflectingStringEscaperUnrestricted;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ReflectingStringEscaper {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ReflectingStringEscaper.class);
    private static int MIN_TIME_LOGGED_MS = 100;

    public static <T> T escapeShallow(T bean) {
        ReflectingStringEscaperUnrestricted<T> escaper = new ReflectingStringEscaperUnrestricted<T>(false, bean);
        return escaper.escape();
    }

    public static <T extends Serializable> T escapeDeepWithCopy(T bean) {
        try {
            long startTime = System.currentTimeMillis();
            T beanClone = BeanUtils.clone(bean);
            long cloneTime = System.currentTimeMillis();
            T result = ReflectingStringEscaper.doEscapeDeep(beanClone);
            long escapeTime = System.currentTimeMillis();
            long timeSpent = escapeTime - startTime;
            if (timeSpent >= (long)MIN_TIME_LOGGED_MS) {
                operationLog.info(String.valueOf(timeSpent) + "ms for escaping (cloning: " + (cloneTime - startTime) + "ms) " + (bean == null ? "" : bean.getClass().getSimpleName()));
            }
            return result;
        }
        catch (Exception ex) {
            LogUtils.logErrorWithFailingAssertion(operationLog, ex.toString());
            ex.printStackTrace();
            return bean;
        }
    }

    public static <T> T escapeDeep(T bean) {
        try {
            long time = System.currentTimeMillis();
            T result = ReflectingStringEscaper.doEscapeDeep(bean);
            long timeSpent = System.currentTimeMillis() - time;
            if (timeSpent >= (long)MIN_TIME_LOGGED_MS) {
                operationLog.info(String.valueOf(timeSpent) + "ms for escaping " + (bean == null ? "" : bean.getClass().getSimpleName()));
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtils.logErrorWithFailingAssertion(operationLog, ex.toString());
            return null;
        }
    }

    private static <T> T doEscapeDeep(T bean) {
        ReflectingStringEscaperUnrestricted<T> escaper = new ReflectingStringEscaperUnrestricted<T>(true, bean);
        return escaper.escape();
    }

    public static <T> T escapeShallowRestricted(T bean, String ... escapedProperties) {
        ReflectingStringEscaperRestricted<T> escaper = new ReflectingStringEscaperRestricted<T>(false, bean, escapedProperties);
        return escaper.escape();
    }

    public static <T> T escapeDeepRestricted(T bean, String ... escapedProperties) {
        ReflectingStringEscaperRestricted<T> escaper = new ReflectingStringEscaperRestricted<T>(true, bean, escapedProperties);
        return escaper.escape();
    }
}

