/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.IDataSetUploader;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import java.io.File;
import java.util.Properties;

public abstract class AbstractStrorageProcessorWithUploader
extends AbstractDelegatingStorageProcessor {
    private final IDataSetUploader uploader;

    public AbstractStrorageProcessorWithUploader(IStorageProcessorTransactional processor, IDataSetUploader uploader) {
        super(processor);
        this.uploader = uploader;
    }

    public AbstractStrorageProcessorWithUploader(Properties properties, IDataSetUploader uploader) {
        super(properties);
        this.uploader = uploader;
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters transactionParameters) {
        IStorageProcessorTransactional.IStorageProcessorTransaction nestedTransaction = super.createTransaction(transactionParameters);
        return new StorageProcessorWithUploaderTransaction(transactionParameters, nestedTransaction, this);
    }

    protected abstract void logDataSetFileError(File var1, Throwable var2);

    static class StorageProcessorWithUploaderTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final transient AbstractStrorageProcessorWithUploader processor;

        StorageProcessorWithUploaderTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction nestedTransaction, AbstractStrorageProcessorWithUploader processor) {
            super(parameters, nestedTransaction);
            this.processor = processor;
        }

        @Override
        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            File storeData = this.nestedTransaction.getStoredDataDirectory();
            File originalData = this.nestedTransaction.tryGetProprietaryData();
            if (originalData == null) {
                throw new ConfigurationFailureException("The original data is no longer available by the wrapped storage processor. Another storage processor should be used.");
            }
            this.processor.uploader.upload(originalData, this.dataSetInformation);
            return storeData;
        }

        @Override
        public IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable exception) {
            try {
                this.nestedTransaction.rollback(exception);
            }
            finally {
                if (this.processor != null) {
                    this.processor.uploader.rollback();
                }
            }
            if (this.processor != null) {
                this.processor.logDataSetFileError(this.incomingDataSetDirectory, exception);
            }
            return IStorageProcessorTransactional.UnstoreDataAction.LEAVE_UNTOUCHED;
        }

        @Override
        public void executeCommit() {
            this.nestedTransaction.commit();
            this.processor.uploader.commit();
        }
    }
}

