/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.path;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

final class PathInfo {
    private static final List<PathInfo> NO_CHILDREN = Collections.emptyList();
    private String fileName;
    private long sizeInBytes;
    private Integer checksumCRC32;
    private PathInfo parent;
    private boolean directory;
    private List<PathInfo> children;
    private Date lastModifiedDate;

    PathInfo() {
    }

    static PathInfo createPathInfo(IHierarchicalContentNode node, boolean computeChecksum) {
        if (!node.exists()) {
            throw new IllegalArgumentException("File does not exist: " + node.getRelativePath());
        }
        PathInfo pathInfo = new PathInfo();
        pathInfo.fileName = node.getName();
        pathInfo.lastModifiedDate = new Date(node.getLastModified());
        pathInfo.directory = node.isDirectory();
        if (pathInfo.directory) {
            pathInfo.children = PathInfo.createPathInfos(node, computeChecksum);
            long sum = 0L;
            for (PathInfo childInfo : pathInfo.children) {
                childInfo.parent = pathInfo;
                sum += childInfo.sizeInBytes;
            }
            pathInfo.sizeInBytes = sum;
        } else {
            pathInfo.sizeInBytes = node.getFileLength();
            pathInfo.checksumCRC32 = computeChecksum ? Integer.valueOf(node.getChecksumCRC32()) : null;
        }
        return pathInfo;
    }

    private static List<PathInfo> createPathInfos(IHierarchicalContentNode node, boolean computeChecksum) {
        if (!node.isDirectory()) {
            throw new IllegalArgumentException("Not a folder: " + node.getRelativePath());
        }
        ArrayList<PathInfo> childInfos = new ArrayList<PathInfo>();
        List<IHierarchicalContentNode> childNodes = node.getChildNodes();
        for (IHierarchicalContentNode child : childNodes) {
            childInfos.add(PathInfo.createPathInfo(child, computeChecksum));
        }
        Collections.sort(childInfos, new Comparator<PathInfo>(){

            @Override
            public int compare(PathInfo p1, PathInfo p2) {
                return p1.getFileName().compareTo(p2.getFileName());
            }
        });
        return childInfos;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Integer getChecksumCRC32() {
        return this.checksumCRC32;
    }

    public PathInfo getParent() {
        return this.parent;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public List<PathInfo> getChildren() {
        return this.children == null ? NO_CHILDREN : Collections.unmodifiableList(this.children);
    }
}

