/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidAuthenticationException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.filesystem.QueueingPathRemoverService;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.etlserver.ConfigProvider;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.common.spring.AbstractServiceWithLogger;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.dss.generic.server.CIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.DataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServiceLogger;
import ch.systemsx.cisd.openbis.dss.generic.server.ICIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.OpenbisSessionTokenCache;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionTokenManager;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.UploadingCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.ArchiverPluginFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.PluginTaskProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDeleter;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.UuidUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class DataStoreService
extends AbstractServiceWithLogger<IDataStoreService>
implements IDataStoreServiceInternal,
InitializingBean {
    private final SessionTokenManager sessionTokenManager;
    private final OpenbisSessionTokenCache sessionTokenCache;
    private final IDataSetCommandExecutorFactory commandExecutorFactory;
    private final MailClientParameters mailClientParameters;
    private final IPluginTaskInfoProvider pluginTaskInfoProvider;
    private IHierarchicalContentProvider hierarchicalContentProvider;
    private IShareIdManager shareIdManager;
    private String cifexAdminUserOrNull;
    private String cifexAdminPasswordOrNull;
    private File storeRoot;
    private File commandQueueDirOrNull;
    private IDataSetCommandExecutor commandExecutor;
    private PutDataSetService putService;
    private ConfigProvider config;

    public DataStoreService(SessionTokenManager sessionTokenManager, OpenbisSessionTokenCache sessionTokenCache, MailClientParameters mailClientParameters, IPluginTaskInfoProvider pluginTaskParameters) {
        this(sessionTokenManager, sessionTokenCache, new IDataSetCommandExecutorFactory(){

            @Override
            public IDataSetCommandExecutor create(File store, File queueDir) {
                return new DataSetCommandExecutor(store, queueDir);
            }
        }, mailClientParameters, pluginTaskParameters);
    }

    DataStoreService(SessionTokenManager sessionTokenManager, OpenbisSessionTokenCache sessionTokenCache, IDataSetCommandExecutorFactory commandExecutorFactory, MailClientParameters mailClientParameters, IPluginTaskInfoProvider pluginTaskParameters) {
        this.sessionTokenManager = sessionTokenManager;
        this.sessionTokenCache = sessionTokenCache;
        this.commandExecutorFactory = commandExecutorFactory;
        this.mailClientParameters = mailClientParameters;
        this.pluginTaskInfoProvider = pluginTaskParameters;
        this.storeRoot = pluginTaskParameters.getStoreRoot();
    }

    void setShareIdManager(IShareIdManager shareIdManager) {
        this.shareIdManager = shareIdManager;
    }

    public final void setCommandQueueDir(String queueDirOrNull) {
        this.commandQueueDirOrNull = StringUtils.isBlank((String)queueDirOrNull) ? null : new File(queueDirOrNull);
    }

    public void setCifexAdminUserOrNull(String cifexAdminUserOrNull) {
        this.cifexAdminUserOrNull = cifexAdminUserOrNull;
    }

    public void setCifexAdminPasswordOrNull(String cifexAdminPasswordOrNull) {
        this.cifexAdminPasswordOrNull = cifexAdminPasswordOrNull;
    }

    public void afterPropertiesSet() {
        String prefix = "Property 'storeRoot' ";
        if (this.storeRoot == null) {
            throw new IllegalStateException(String.valueOf(prefix) + "not set.");
        }
        String storeRootPath = this.storeRoot.getAbsolutePath();
        if (this.storeRoot.isFile()) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "is a file instead of a directory: " + storeRootPath);
        }
        if (!this.storeRoot.exists()) {
            if (!this.storeRoot.mkdirs()) {
                throw new IOExceptionUnchecked(new IOException("Couldn't create root directory of the data store: " + storeRootPath));
            }
            if (this.operationLog.isInfoEnabled()) {
                this.operationLog.info("Creates root directory of the data store: " + storeRootPath);
            }
        }
        if (this.commandQueueDirOrNull == null) {
            this.commandQueueDirOrNull = this.storeRoot;
        }
        this.commandExecutor = this.commandExecutorFactory.create(this.storeRoot, this.commandQueueDirOrNull);
        this.migrateStore();
    }

    @Override
    public void initialize() {
        this.commandExecutor.start();
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info("Command executor started.");
        }
        this.getShareIdManager().isKnown("");
        if (this.operationLog.isInfoEnabled()) {
            this.operationLog.info("Initialization finished.");
        }
    }

    private void migrateStore() {
        File defaultShare = new File(this.storeRoot, "1");
        if (!defaultShare.exists()) {
            File[] stores;
            if (!defaultShare.mkdirs()) {
                throw new IOExceptionUnchecked(new IOException("Couldn't create default share in data store: " + defaultShare));
            }
            File[] fileArray = stores = this.storeRoot.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return UuidUtil.isValidUUID(name);
                }
            });
            int n = stores.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.renameTo(new File(defaultShare, file.getName()))) {
                    throw new IOExceptionUnchecked(new IOException("Couldn't move '" + file + "' into default share '" + defaultShare + "'."));
                }
                ++n2;
            }
            this.operationLog.info("Store migrated to default share");
        }
    }

    @Override
    public IDataStoreService createLogger(IInvocationLoggerContext context) {
        return new DataStoreServiceLogger(this.operationLog, context);
    }

    @Override
    public int getVersion(String sessionToken) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return 9;
    }

    @Override
    public List<String> getKnownDataSets(String sessionToken, List<? extends IDatasetLocation> dataSets, boolean ignoreNonExistingLocation) throws InvalidAuthenticationException {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        IServiceConversationProgressListener listener = ServiceConversationsThreadContext.getProgressListener();
        ArrayList<String> knownLocations = new ArrayList<String>();
        IShareIdManager manager = this.getShareIdManager();
        int index = 0;
        for (IDatasetLocation iDatasetLocation : dataSets) {
            String datasetCode = iDatasetLocation.getDataSetCode();
            String location = iDatasetLocation.getDataSetLocation();
            manager.lock(datasetCode);
            try {
                if (manager.isKnown(datasetCode) && (ignoreNonExistingLocation || new File(new File(this.storeRoot, manager.getShareId(datasetCode)), location).exists())) {
                    knownLocations.add(location);
                }
            }
            finally {
                manager.releaseLock(datasetCode);
            }
            listener.update("getKnownDataSets", dataSets.size(), ++index);
        }
        return knownLocations;
    }

    @Override
    public void uploadDataSetsToCIFEX(String sessionToken, List<AbstractExternalData> dataSets, DataSetUploadContext context) throws InvalidAuthenticationException {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        if (context.getCifexURL() == null) {
            throw new ConfigurationFailureException("Upload of data sets to CIFEX not possible: no CIFEX URL configured.");
        }
        ICIFEXRPCServiceFactory serviceFactory = this.createCIFEXRPCServiceFactory(context.getCifexURL());
        ICIFEXComponent cifex = serviceFactory.createCIFEXComponent();
        String userID = context.getUserID();
        String password = context.getPassword();
        if (!UploadingCommand.canLoginToCIFEX(cifex, context.isUserAuthenticated(), userID, password, this.cifexAdminUserOrNull, this.cifexAdminPasswordOrNull)) {
            throw new InvalidSessionException("User failed to be authenticated by CIFEX.");
        }
        this.commandExecutor.scheduleUploadingDataSetsToCIFEX(serviceFactory, this.mailClientParameters, dataSets, context, this.cifexAdminUserOrNull, this.cifexAdminPasswordOrNull);
    }

    protected ICIFEXRPCServiceFactory createCIFEXRPCServiceFactory(String cifexURL) {
        return new CIFEXRPCServiceFactory(cifexURL);
    }

    @Override
    public TableModel createReportFromDatasets(String sessionToken, String userSessionToken, String serviceKey, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return this.internalCreateReportFromDatasets(userSessionToken, serviceKey, datasets, userId, userEmailOrNull);
    }

    @Override
    public void processDatasets(String sessionToken, String userSessionToken, String serviceKey, List<DatasetDescription> datasets, Map<String, String> parameterBindings, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        PluginTaskProvider<IProcessingPluginTask> plugins = this.pluginTaskInfoProvider.getProcessingPluginsProvider();
        IProcessingPluginTask task = plugins.getPluginInstance(serviceKey);
        DatastoreServiceDescription pluginDescription = plugins.getPluginDescription(serviceKey);
        this.commandExecutor.scheduleProcessDatasets(task, datasets, parameterBindings, userId, userEmailOrNull, userSessionToken, pluginDescription, this.mailClientParameters);
    }

    @Override
    public void unarchiveDatasets(String sessionToken, String userSessionToken, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        String description = "Unarchiving";
        UnarchiveProcessingPluginTask task = new UnarchiveProcessingPluginTask(this.getArchiverPlugin());
        this.scheduleTask(sessionToken, userSessionToken, description, task, datasets, userId, userEmailOrNull);
    }

    @Override
    public void archiveDatasets(String sessionToken, String userSessionToken, List<DatasetDescription> datasets, String userId, String userEmailOrNull, boolean removeFromDataStore) {
        String description = removeFromDataStore ? "Archiving" : "Copying data sets to archive";
        ArchiveProcessingPluginTask task = new ArchiveProcessingPluginTask(this.getArchiverPlugin(), removeFromDataStore);
        this.scheduleTask(sessionToken, userSessionToken, description, task, datasets, userId, userEmailOrNull);
    }

    @Override
    public IArchiverPlugin getArchiverPlugin() {
        ArchiverPluginFactory factory = this.pluginTaskInfoProvider.getArchiverPluginFactory();
        return factory.createInstance(this.storeRoot);
    }

    @Override
    public IDataSetDirectoryProvider getDataSetDirectoryProvider() {
        return new DataSetDirectoryProvider(this.storeRoot, this.getShareIdManager());
    }

    @Override
    public TableModel createReportFromAggregationService(String sessionToken, String userSessionToken, String serviceKey, Map<String, Object> parameters, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        return this.internalCreateReportFromAggregationService(userSessionToken, serviceKey, parameters, userId, userEmailOrNull);
    }

    private IMailClient createEMailClient() {
        return new MailClient(this.mailClientParameters);
    }

    private void scheduleTask(String sessionToken, String userSessionToken, String description, IProcessingPluginTask processingTask, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        DatastoreServiceDescription pluginDescription = DatastoreServiceDescription.processing(description, description, null, null);
        Map<String, String> parameterBindings = Collections.emptyMap();
        this.commandExecutor.scheduleProcessDatasets(processingTask, datasets, parameterBindings, userId, userEmailOrNull, userSessionToken, pluginDescription, this.mailClientParameters);
    }

    private static ArchiverTaskContext createContext(DataSetProcessingContext context) {
        return new ArchiverTaskContext(context.getDirectoryProvider(), context.getHierarchicalContentProvider());
    }

    @Override
    public LinkModel retrieveLinkFromDataSet(String sessionToken, String serviceKey, DatasetDescription dataSet) {
        this.sessionTokenManager.assertValidSessionToken(sessionToken);
        PluginTaskProvider<IReportingPluginTask> reportingPlugins = this.pluginTaskInfoProvider.getReportingPluginsProvider();
        IReportingPluginTask task = reportingPlugins.getPluginInstance(serviceKey);
        return task.createLink(dataSet);
    }

    @Override
    public IDataSetDeleter getDataSetDeleter() {
        return this.commandExecutor;
    }

    @Override
    public String putDataSet(String sessionToken, String dropboxName, CustomImportFile customImportFile) {
        PutDataSetService service = this.getPutDataSetService();
        return service.putDataSet(sessionToken, dropboxName, customImportFile);
    }

    @Override
    public void cleanupSession(String userSessionToken) {
        this.sessionTokenCache.removeSessionToken(userSessionToken);
        File sessionWorkspace = new File(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken);
        if (sessionWorkspace.exists()) {
            QueueingPathRemoverService.removeRecursively(sessionWorkspace);
        }
    }

    private PutDataSetService getPutDataSetService() {
        if (this.putService == null) {
            this.putService = new PutDataSetService(ServiceProvider.getOpenBISService(), this.operationLog);
            this.putService.setStoreDirectory(this.storeRoot);
        }
        return this.putService;
    }

    private IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    public void setConfig(ConfigProvider config) {
        this.config = config;
    }

    @Override
    public TableModel internalCreateReportFromDatasets(String userSessionToken, String serviceKey, List<DatasetDescription> datasets, String userId, String userEmailOrNull) {
        PluginTaskProvider<IReportingPluginTask> reportingPlugins = this.pluginTaskInfoProvider.getReportingPluginsProvider();
        IReportingPluginTask task = reportingPlugins.getPluginInstance(serviceKey);
        IShareIdManager manager = this.getShareIdManager();
        try {
            String dssCode = this.config.getDataStoreCode();
            for (DatasetDescription dataSet : datasets) {
                if (!dssCode.equals(dataSet.getDataStoreCode())) continue;
                manager.lock(dataSet.getDataSetCode());
            }
            IMailClient mailClient = this.createEMailClient();
            TableModel tableModel = task.createReport(datasets, new DataSetProcessingContext(this.getHierarchicalContentProvider(), new DataSetDirectoryProvider(this.storeRoot, manager), new SessionWorkspaceProvider(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken), new HashMap<String, String>(), mailClient, userId, userEmailOrNull, userSessionToken));
            return tableModel;
        }
        finally {
            manager.releaseLocks();
        }
    }

    @Override
    public TableModel internalCreateReportFromAggregationService(String userSessionToken, String serviceKey, Map<String, Object> parameters, String userId, String userEmailOrNull) {
        PluginTaskProvider<IReportingPluginTask> reportingPlugins = this.pluginTaskInfoProvider.getReportingPluginsProvider();
        IReportingPluginTask task = reportingPlugins.getPluginInstance(serviceKey);
        IShareIdManager manager = this.getShareIdManager();
        try {
            IMailClient mailClient = this.createEMailClient();
            TableModel tableModel = task.createAggregationReport(parameters, new DataSetProcessingContext(this.getHierarchicalContentProvider(), new DataSetDirectoryProvider(this.storeRoot, manager), new SessionWorkspaceProvider(this.pluginTaskInfoProvider.getSessionWorkspaceRootDir(), userSessionToken), new HashMap<String, String>(), mailClient, userId, userEmailOrNull, userSessionToken));
            return tableModel;
        }
        finally {
            manager.releaseLocks();
        }
    }

    private static class ArchiveProcessingPluginTask
    implements IProcessingPluginTask {
        private static final long serialVersionUID = 1L;
        private IArchiverPlugin archiverTask;
        private boolean removeFromDataStore;

        public ArchiveProcessingPluginTask(IArchiverPlugin archiverTask, boolean removeFromDataStore) {
            this.archiverTask = archiverTask;
            this.removeFromDataStore = removeFromDataStore;
        }

        @Override
        public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
            ArchiverTaskContext archiverContext = DataStoreService.createContext(context);
            return this.archiverTask.archive(datasets, archiverContext, this.removeFromDataStore);
        }
    }

    private static class UnarchiveProcessingPluginTask
    implements IProcessingPluginTask {
        private static final long serialVersionUID = 1L;
        private IArchiverPlugin archiverTask;

        public UnarchiveProcessingPluginTask(IArchiverPlugin archiverTask) {
            this.archiverTask = archiverTask;
        }

        @Override
        public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
            ArchiverTaskContext archiverContext = DataStoreService.createContext(context);
            return this.archiverTask.unarchive(datasets, archiverContext);
        }
    }
}

