/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.FilteredHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.ZipBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.ZipDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IdentifierAttributeMappingManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.BasicZipFile;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DistributedPackagingDataSetFileOperationsManager
implements IDataSetFileOperationsManager {
    static final String MAPPING_FILE_KEY = "mapping-file";
    static final String CREATE_ARCHIVES_KEY = "mapping-file.create-archives";
    static final String DEFAULT_DESTINATION_KEY = "default-archive-folder";
    static final String WITH_SHARDING_KEY = "with-sharding";
    static final String COMPRESS_KEY = "compressing";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DistributedPackagingDataSetFileOperationsManager.class);
    private static final IHierarchicalContentNodeFilter FILTER = new IHierarchicalContentNodeFilter(){

        @Override
        public boolean accept(IHierarchicalContentNode node) {
            return !"meta-data.tsv".equals(node.getRelativePath());
        }
    };
    private boolean compress;
    private File defaultFolder;
    private boolean withSharding;
    private String mappingFilePathOrNull;
    private boolean createArchives;
    private transient IEncapsulatedOpenBISService service;
    private transient IHierarchicalContentProvider contentProvider;
    private transient IDataSetDirectoryProvider directoryProvider;
    private transient IdentifierAttributeMappingManager archiveFolderMapping;

    public DistributedPackagingDataSetFileOperationsManager(Properties properties) {
        this(properties, null, null, null);
    }

    DistributedPackagingDataSetFileOperationsManager(Properties properties, IEncapsulatedOpenBISService service, IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider directoryProvider) {
        this.service = service;
        this.contentProvider = contentProvider;
        this.directoryProvider = directoryProvider;
        this.compress = PropertyUtils.getBoolean(properties, COMPRESS_KEY, true);
        this.withSharding = PropertyUtils.getBoolean(properties, WITH_SHARDING_KEY, false);
        this.defaultFolder = new File(PropertyUtils.getMandatoryProperty(properties, DEFAULT_DESTINATION_KEY));
        if (!this.defaultFolder.isDirectory()) {
            throw new ConfigurationFailureException("Default archive folder '" + this.defaultFolder.getPath() + "' doesn't exist or is not a folder.");
        }
        this.mappingFilePathOrNull = properties.getProperty(MAPPING_FILE_KEY);
        this.createArchives = PropertyUtils.getBoolean(properties, CREATE_ARCHIVES_KEY, false);
        this.getArchiveFolderMapping();
    }

    @Override
    public Status copyToDestination(File originalData, DatasetDescription datasetDescription) {
        AbstractExternalData dataSet = this.getDataSetWithAllMetaData(datasetDescription);
        IShareIdManager shareIdManager = this.getDirectoryProvider().getShareIdManager();
        DataSetExistenceChecker dataSetExistenceChecker = new DataSetExistenceChecker(this.getDirectoryProvider(), TimingParameters.create(new Properties()));
        Status status = Status.OK;
        String dataSetCode = datasetDescription.getDataSetCode();
        File file = this.getArchiveFile(datasetDescription);
        shareIdManager.lock(dataSetCode);
        AbstractDataSetPackager dataSetPackager = null;
        try {
            try {
                dataSetPackager = this.createPackager(file, dataSetExistenceChecker);
                dataSetPackager.addDataSetTo("", dataSet);
                operationLog.info("Data set '" + dataSetCode + "' archived: " + file);
            }
            catch (Exception ex) {
                status = Status.createError(ex.toString());
                operationLog.error("Couldn't create package file: " + file, ex);
                if (dataSetPackager != null) {
                    try {
                        dataSetPackager.close();
                    }
                    catch (Exception ex2) {
                        status = Status.createError("Couldn't close package file: " + file + ": " + ex2);
                    }
                }
                shareIdManager.releaseLock(dataSetCode);
            }
        }
        finally {
            if (dataSetPackager != null) {
                try {
                    dataSetPackager.close();
                }
                catch (Exception ex) {
                    status = Status.createError("Couldn't close package file: " + file + ": " + ex);
                }
            }
            shareIdManager.releaseLock(dataSetCode);
        }
        return status;
    }

    private AbstractDataSetPackager createPackager(File file, DataSetExistenceChecker dataSetExistenceChecker) {
        return new ZipDataSetPackager(file, this.compress, this.getContentProvider(), dataSetExistenceChecker);
    }

    @Override
    public Status retrieveFromDestination(File originalData, DatasetDescription datasetDescription) {
        File file = this.getArchiveFile(datasetDescription);
        BasicZipFile zipFile = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipFile = new BasicZipFile((ReadOnlyFile)new SimpleReadOnlyFile(file), "UTF-8", true, false);
            Enumeration entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File outputFile = new File(originalData, entry.getName());
                if (!entry.isDirectory()) {
                    if ("meta-data.tsv".equals(entry.getName())) continue;
                    outputFile.getParentFile().mkdirs();
                    BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
                    fileOutputStream = new FileOutputStream(outputFile);
                    BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
                    try {
                        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                        IOUtils.closeQuietly((OutputStream)outputStream);
                    }
                }
                if (outputFile.isFile()) {
                    throw new EnvironmentFailureException("Could not extract directory '" + outputFile + "' because it exists already as a plain file.");
                }
                outputFile.mkdirs();
            }
            operationLog.info("Data set '" + datasetDescription.getDataSetCode() + "' unzipped from archive '" + file.getPath() + "' to '" + originalData + "'.");
            Status status = Status.OK;
            return status;
        }
        catch (Exception ex) {
            Status status = Status.createError(ex.toString());
            return status;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    @Override
    public Status deleteFromDestination(IDatasetLocation dataset) {
        File archiveFile = this.tryFindArchiveFile(dataset);
        if (archiveFile == null) {
            operationLog.warn("Archive file for data set '" + dataset.getDataSetCode() + "' no konger exists.");
            return Status.OK;
        }
        boolean success = archiveFile.delete();
        return success ? Status.OK : Status.createError("Couldn't delete archive file '" + archiveFile + "'.");
    }

    private File tryFindArchiveFile(IDatasetLocation datasetLocation) {
        File archiveFile = this.getArchiveFile(this.defaultFolder, datasetLocation, false);
        if (archiveFile.isFile()) {
            return archiveFile;
        }
        Collection<File> folders = this.getArchiveFolderMapping().getAllFolders();
        for (File folder : folders) {
            archiveFile = this.getArchiveFile(folder, datasetLocation, false);
            if (!archiveFile.isFile()) continue;
            return archiveFile;
        }
        return null;
    }

    @Override
    public Status markAsDeleted(IDatasetLocation dataset) {
        File archiveFile = this.tryFindArchiveFile(dataset);
        if (archiveFile == null) {
            operationLog.warn("Archive file for data set '" + dataset.getDataSetCode() + "' no konger exists.");
            return Status.OK;
        }
        String relPath = String.valueOf(this.withSharding ? String.valueOf(dataset.getDataSetLocation()) + "/" : "") + this.createPackageFileName(dataset);
        String path = archiveFile.getPath();
        int index = path.lastIndexOf(relPath);
        File archiveFolder = new File(path.substring(0, index));
        File folderOfMarkers = new File(archiveFolder, "DELETED");
        folderOfMarkers.mkdirs();
        File markerFile = new File(folderOfMarkers, dataset.getDataSetCode());
        try {
            if (!markerFile.createNewFile()) {
                throw new IOException("Marker file already exists.");
            }
            return Status.OK;
        }
        catch (IOException ex) {
            String message = "Couldn't create marker file '" + markerFile + "': " + ex;
            operationLog.error(message, ex);
            return Status.createError(message);
        }
    }

    @Override
    public BooleanStatus isSynchronizedWithDestination(File originalData, DatasetDescription datasetDescription) {
        return BooleanStatus.createFalse();
    }

    @Override
    public BooleanStatus isPresentInDestination(DatasetDescription datasetDescription) {
        return BooleanStatus.createFalse();
    }

    @Override
    public boolean isHosted() {
        return false;
    }

    @Override
    public IHierarchicalContent getAsHierarchicalContent(DatasetDescription dataset) {
        return new FilteredHierarchicalContent(new ZipBasedHierarchicalContent(this.getArchiveFile(dataset)), FILTER);
    }

    private AbstractExternalData getDataSetWithAllMetaData(DatasetDescription datasetDescription) {
        AbstractExternalData dataSet = this.getService().tryGetDataSet(datasetDescription.getDataSetCode());
        String experimentIdentifier = datasetDescription.getExperimentIdentifier();
        dataSet.setExperiment(this.getService().tryGetExperiment(ExperimentIdentifierFactory.parse(experimentIdentifier)));
        String sampleIdentifier = datasetDescription.getSampleIdentifier();
        if (sampleIdentifier != null) {
            dataSet.setSample(this.getService().tryGetSampleWithExperiment(SampleIdentifierFactory.parse(sampleIdentifier)));
        }
        return dataSet;
    }

    private File getArchiveFile(DatasetDescription datasetDescription) {
        File folder = this.getArchiveFolderMapping().getArchiveFolder(datasetDescription, this.defaultFolder);
        return this.getArchiveFile(folder, datasetDescription, true);
    }

    private File getArchiveFile(File baseFolder, IDatasetLocation datasetLocation, boolean forWriting) {
        File folder = this.getArchiveFolder(baseFolder, datasetLocation, forWriting);
        return new File(folder, this.createPackageFileName(datasetLocation));
    }

    private String createPackageFileName(IDatasetLocation datasetLocation) {
        return String.valueOf(datasetLocation.getDataSetCode()) + ".zip";
    }

    private File getArchiveFolder(File baseFolder, IDatasetLocation datasetLocation, boolean forWriting) {
        File folder = baseFolder;
        if (this.withSharding) {
            folder = new File(folder, datasetLocation.getDataSetLocation());
            if (forWriting && !folder.exists()) {
                folder.mkdirs();
            }
        }
        return folder;
    }

    private IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    private IHierarchicalContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.contentProvider;
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        if (this.directoryProvider == null) {
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        return this.directoryProvider;
    }

    private IdentifierAttributeMappingManager getArchiveFolderMapping() {
        if (this.archiveFolderMapping == null) {
            this.archiveFolderMapping = new IdentifierAttributeMappingManager(this.mappingFilePathOrNull, this.createArchives);
        }
        return this.archiveFolderMapping;
    }
}

