/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DOMUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IRegistratorAndModifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IRegistratorHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimplePersonRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public final class PersonRenderer {
    private static final char EMAIL_END = '>';
    private static final char EMAIL_START = '<';
    private static final char LOGIN_END = ']';
    private static final char LOGIN_START = '[';
    public static final GridCellRenderer<BaseEntityModel<?>> REGISTRATOR_RENDERER = new GridCellRenderer<BaseEntityModel<?>>(){

        public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
            Person registrator = ((IRegistratorHolder)((TableModelRowWithObject)model.getBaseObject()).getObjectOrNull()).getRegistrator();
            return PersonRenderer.createPersonAnchor(registrator);
        }
    };
    public static final GridCellRenderer<BaseEntityModel<?>> MODIFIER_RENDERER = new GridCellRenderer<BaseEntityModel<?>>(){

        public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
            Person modifier = null;
            modifier = model.get(property) != null && model.get(property) instanceof Person ? (Person)model.get(property) : ((IRegistratorAndModifierHolder)((TableModelRowWithObject)model.getBaseObject()).getObjectOrNull()).getModifier();
            return PersonRenderer.createPersonAnchor(modifier);
        }
    };

    private PersonRenderer() {
    }

    public static final String createPersonAnchor(Person person) {
        String personName = PersonRenderer.createPersonName(person).toString();
        return PersonRenderer.createPersonAnchor(person, personName);
    }

    private static StringBuilder createPersonName(Person person) {
        return SimplePersonRenderer.createPersonName(person);
    }

    public static final String createPersonAnchor(Person personOrNull, String personName) {
        if (personOrNull == null) {
            return personName;
        }
        String email = personOrNull.getEmail();
        if (!StringUtils.isBlank(email)) {
            Element anchor = DOMUtils.createAnchorElement(null, "mailto:" + email, email);
            DOM.setInnerText((Element)anchor, (String)StringEscapeUtils.unescapeHtml(personName));
            return DOM.toString((Element)anchor);
        }
        return personName;
    }

    public static final String toString(Person person) {
        String email;
        assert (person != null) : "Given person can not be null.";
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)PersonRenderer.createPersonName(person));
        String userId = person.getUserId();
        if (!StringUtils.isBlank(userId)) {
            if (builder.length() != 0) {
                builder.append(' ');
            }
            builder.append('[');
            builder.append(userId);
            builder.append(']');
        }
        if (!StringUtils.isBlank(email = person.getEmail())) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append('<');
            builder.append(email);
            builder.append('>');
        }
        return builder.toString();
    }
}

