/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.calculator;

import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ColumnDefinition;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ColumnGroup;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ComparableCellValueHelper;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ITableDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Row {
    private final Map<String, List<ColumnDefinition>> definitionsByProperties = new HashMap<String, List<ColumnDefinition>>();
    private final ITableDataProvider provider;
    private List<? extends Comparable<?>> rowValues;

    Row(ITableDataProvider provider) {
        this.provider = provider;
    }

    void setRowData(List<? extends Comparable<?>> rowValues) {
        this.rowValues = rowValues;
    }

    public Object col(String columnID) {
        Comparable<?> value = this.provider.getValue(columnID, this.rowValues);
        if (value instanceof ISerializableComparable) {
            return ComparableCellValueHelper.unwrap((ISerializableComparable)value);
        }
        return value;
    }

    public List<ColumnDefinition> colDefs(String propertyKeyOrNull) {
        List<ColumnDefinition> definitions = this.definitionsByProperties.get(propertyKeyOrNull);
        if (definitions == null) {
            definitions = new ArrayList<ColumnDefinition>();
            Collection<String> columnIDs = this.provider.getAllColumnIDs();
            for (String columnID : columnIDs) {
                if (propertyKeyOrNull != null && this.provider.tryToGetProperty(columnID, propertyKeyOrNull) == null) continue;
                definitions.add(new ColumnDefinition(columnID, this.provider));
            }
            this.definitionsByProperties.put(propertyKeyOrNull, definitions);
        }
        return Collections.unmodifiableList(definitions);
    }

    public List<Object> cols(String propertyKey, String propertyValue) {
        ArrayList<Object> values = new ArrayList<Object>();
        List<ColumnDefinition> definitions = this.colDefs(propertyKey);
        for (ColumnDefinition definition : definitions) {
            String property = definition.property(propertyKey);
            if (!propertyValue.equals(property)) continue;
            values.add(this.col(definition.id()));
        }
        return Collections.unmodifiableList(values);
    }

    public List<ColumnGroup> colsGroupedBy(String propertyKey) {
        LinkedHashMap<String, ArrayList<Object>> map = new LinkedHashMap<String, ArrayList<Object>>();
        List<ColumnDefinition> definitions = this.colDefs(propertyKey);
        for (ColumnDefinition definition : definitions) {
            String property = definition.property(propertyKey);
            ArrayList<Object> values = (ArrayList<Object>)map.get(property);
            if (values == null) {
                values = new ArrayList<Object>();
                map.put(property, values);
            }
            values.add(this.col(definition.id()));
        }
        Set entrySet = map.entrySet();
        ArrayList<ColumnGroup> groups = new ArrayList<ColumnGroup>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            groups.add(new ColumnGroup((String)entry.getKey(), (List)entry.getValue()));
        }
        return Collections.unmodifiableList(groups);
    }
}

