/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExistingSpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.List;

public class NewExternalDataPredicate
extends AbstractPredicate<NewExternalData> {
    private final SampleOwnerIdentifierPredicate sampleOwnerIdentifierPredicate = new SampleOwnerIdentifierPredicate(true, true);
    private final ExistingSpaceIdentifierPredicate experimentOwnerIdentifierPredicate = new ExistingSpaceIdentifierPredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.sampleOwnerIdentifierPredicate.init(provider);
        this.experimentOwnerIdentifierPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "new data set";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewExternalData value) {
        if (NewExternalDataPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        SampleIdentifier sampleIdentifier = value.getSampleIdentifierOrNull();
        if (sampleIdentifier != null) {
            return this.sampleOwnerIdentifierPredicate.evaluate(person, allowedRoles, sampleIdentifier);
        }
        return this.experimentOwnerIdentifierPredicate.evaluate(person, allowedRoles, value.getExperimentIdentifierOrNull());
    }
}

