/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.batch;

import ch.systemsx.cisd.openbis.generic.server.batch.AbstractBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import java.util.List;

public class DataSetCheckBeforeBatchUpdate
extends AbstractBatchOperation<DataSetBatchUpdatesDTO> {
    private final IDataSetTable businessTable;
    private final List<DataSetBatchUpdatesDTO> entities;

    public DataSetCheckBeforeBatchUpdate(IDataSetTable businessTable, List<DataSetBatchUpdatesDTO> entities) {
        super(null);
        this.businessTable = businessTable;
        this.entities = entities;
    }

    @Override
    public void execute(List<DataSetBatchUpdatesDTO> updates) {
        this.businessTable.checkBeforeUpdate(updates);
    }

    @Override
    public List<DataSetBatchUpdatesDTO> getAllEntities() {
        return this.entities;
    }

    @Override
    public String getEntityName() {
        return "data set";
    }

    @Override
    public String getOperationName() {
        return "checkBeforeUpdate";
    }
}

