/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="external_data_management_systems")
public class ExternalDataManagementSystemPE
extends AbstractIdAndCodeHolder<ExternalDataManagementSystemPE> {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private DatabaseInstancePE databaseInstance;
    private String code;
    private String label;
    private String urlTemplate;
    private boolean openBIS;

    @Override
    @Id
    @SequenceGenerator(name="EXTERNAL_DATA_MANAGEMENT_SYSTEM_ID_SEQ", sequenceName="EXTERNAL_DATA_MANAGEMENT_SYSTEM_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EXTERNAL_DATA_MANAGEMENT_SYSTEM_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @Override
    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Column(name="url_template")
    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    @Column(name="is_openbis")
    @NotNull
    public boolean isOpenBIS() {
        return this.openBIS;
    }

    public void setOpenBIS(boolean openBIS) {
        this.openBIS = openBIS;
    }
}

