/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.ValidationUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class SimplePropertyValidator {
    private static final String[] DATE_PATTERNS = SimplePropertyValidator.createDatePatterns();
    private static final Map<DataTypeCode, IDataTypeValidator> dataTypeValidators = SimplePropertyValidator.createDataTypeValidators();

    private static final Map<DataTypeCode, IDataTypeValidator> createDataTypeValidators() {
        EnumMap<DataTypeCode, IDataTypeValidator> map = new EnumMap<DataTypeCode, IDataTypeValidator>(DataTypeCode.class);
        map.put(DataTypeCode.BOOLEAN, new BooleanValidator());
        map.put(DataTypeCode.VARCHAR, new VarcharValidator());
        map.put(DataTypeCode.TIMESTAMP, new TimestampValidator());
        map.put(DataTypeCode.INTEGER, new IntegerValidator());
        map.put(DataTypeCode.REAL, new RealValidator());
        map.put(DataTypeCode.HYPERLINK, new HyperlinkValidator());
        map.put(DataTypeCode.MULTILINE_VARCHAR, new VarcharValidator());
        return map;
    }

    private static final String[] createDatePatterns() {
        ArrayList<String> datePatterns = new ArrayList<String>();
        SupportedDatePattern[] supportedDatePatternArray = SupportedDatePattern.values();
        int n = supportedDatePatternArray.length;
        int n2 = 0;
        while (n2 < n) {
            SupportedDatePattern supportedPattern = supportedDatePatternArray[n2];
            datePatterns.add(supportedPattern.getPattern());
            ++n2;
        }
        return datePatterns.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public boolean canValidate(DataTypeCode entityDataType) {
        return dataTypeValidators.get(entityDataType) != null;
    }

    public final String validatePropertyValue(DataTypeCode entityDataType, String value) throws UserFailureException {
        assert (value != null) : "Unspecified value.";
        if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX)) {
            return value;
        }
        IDataTypeValidator dataTypeValidator = dataTypeValidators.get(entityDataType);
        assert (dataTypeValidator != null) : String.format("No IDataTypeValidator implementation specified for '%s'.", entityDataType);
        return dataTypeValidator.validate(value);
    }

    public static final class BooleanValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            PropertyUtils.Boolean bool = PropertyUtils.Boolean.getBoolean(value);
            if (bool == null) {
                throw UserFailureException.fromTemplate("Boolean value '%s' has improper format. It should be either 'true' or 'false'.", value);
            }
            return Boolean.toString(bool.toBoolean());
        }
    }

    private static final class HyperlinkValidator
    implements IDataTypeValidator {
        private HyperlinkValidator() {
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            if (!ValidationUtilities.HyperlinkValidationHelper.isProtocolValid(value)) {
                throw UserFailureException.fromTemplate("Hyperlink '%s' should start with one of the following protocols: '%s'", value, ValidationUtilities.HyperlinkValidationHelper.getValidProtocolsAsString());
            }
            if (!ValidationUtilities.HyperlinkValidationHelper.isFormatValid(value)) {
                throw UserFailureException.fromTemplate("Hyperlink value '%s' has improper format.", value);
            }
            return value;
        }
    }

    public static interface IDataTypeValidator {
        public String validate(String var1) throws UserFailureException;
    }

    public static final class IntegerValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            try {
                Long.parseLong(value);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                throw UserFailureException.fromTemplate("Integer value '%s' has improper format.", value);
            }
        }
    }

    public static final class RealValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            try {
                Double.parseDouble(value);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                throw UserFailureException.fromTemplate("Double value '%s' has improper format.", value);
            }
        }
    }

    public static enum SupportedDatePattern {
        DAYS_DATE_PATTERN("yyyy-MM-dd"),
        MINUTES_DATE_PATTERN("yyyy-MM-dd HH:mm"),
        SECONDS_DATE_PATTERN("yyyy-MM-dd HH:mm:ss"),
        US_DATE_PATTERN("M/d/yy"),
        US_DATE_TIME_PATTERN("M/d/yy h:mm a"),
        US_DATE_TIME_24_PATTERN("M/d/yy HH:mm"),
        CANONICAL_DATE_PATTERN("yyyy-MM-dd HH:mm:ss Z"),
        RENDERED_CANONICAL_DATE_PATTERN("yyyy-MM-dd HH:mm:ss ZZZZ");

        private final String pattern;

        private SupportedDatePattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }
    }

    public static final class TimestampValidator
    implements IDataTypeValidator {
        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            try {
                Date date = DateUtils.parseDate((String)value, (String[])DATE_PATTERNS);
                return DateFormatUtils.format((Date)date, (String)SupportedDatePattern.CANONICAL_DATE_PATTERN.getPattern());
            }
            catch (ParseException parseException) {
                throw UserFailureException.fromTemplate("Date value '%s' has improper format. It must be one of '%s'.", value, Arrays.toString(DATE_PATTERNS));
            }
        }
    }

    private static final class VarcharValidator
    implements IDataTypeValidator {
        private VarcharValidator() {
        }

        @Override
        public final String validate(String value) throws UserFailureException {
            assert (value != null) : "Unspecified value.";
            return value;
        }
    }
}

