/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXDownloader;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FileDownloadCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "download";
    private static FileDownloadCommand instance;
    private Parameters parameters;
    private static final Pattern FILE_ID_LINK_PATTERN;

    static {
        FILE_ID_LINK_PATTERN = Pattern.compile("fileId=([0-9]+)");
    }

    private FileDownloadCommand() {
        super(NAME);
    }

    @Override
    protected Parameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new Parameters(this.arguments);
        }
        return this.parameters;
    }

    public static final synchronized FileDownloadCommand getInstance() {
        if (instance == null) {
            instance = new FileDownloadCommand();
        }
        return instance;
    }

    private String getPassphraseOrExit(String label) {
        String passphrase = this.tryGetPassphrase(label, this.parameters.getPassphrase());
        if (StringUtils.isBlank((String)passphrase)) {
            System.err.println("No password has been specified.");
            System.exit(1);
        }
        return passphrase;
    }

    @Override
    protected boolean isHelpRequest(String[] args) {
        this.arguments = args;
        return this.getParameters().isHelpRequest();
    }

    @Override
    protected int execute(String sessionToken, ICIFEXComponent cifex, String[] args) throws UserFailureException, EnvironmentFailureException {
        ICIFEXDownloader downloader = cifex.createDownloader(sessionToken);
        this.addConsoleProgressListener(downloader, false, this.getParameters().beQuiet());
        String passphrase = this.getParameters().isDecrypt() ? this.getPassphraseOrExit("Passphrase: ") : null;
        File file = downloader.download(this.getParameters().getFileID(), this.getParameters().getDirectory(), this.getParameters().getName(), this.getParameters().isOverwriteOutputFile());
        if (this.getParameters().isDecrypt()) {
            File clearTextFile = OpenPGPSymmetricKeyEncryption.decrypt(file, this.getParameters().getClearName(), passphrase, true);
            if (this.getParameters().getName() == null) {
                System.out.println("\nDecrypted file is '" + clearTextFile + "'.");
            }
        }
        return 0;
    }

    private static class Parameters
    extends MinimalParameters {
        @Option(name="d", longName="directory", metaVar="DIR", usage="Directory to download the file to.")
        private File directory;
        @Option(name="n", longName="name", metaVar="FILE", usage="File name to use for the downloaded file (instead of the one stored in CIFEX).")
        private String name;
        @Option(name="q", longName="quiet", usage="Suppress progress reporting.")
        private boolean quiet;
        @Option(name="D", longName="decrypt", usage="Decrypt file after downloading.")
        private boolean decrypt;
        @Option(name="p", longName="passphrase", metaVar="STRING", usage="The pass phrase to use for encryption.")
        private String passphrase;
        @Option(name="O", longName="overwrote-output-file", metaVar="FLAG", usage="Whether an already existing output file for the local decrypted file should be silently overwritten (only used if decryption is enabled).")
        private boolean overwriteOutputFile;
        private long fileID;

        public Parameters(String[] args) {
            super(args, FileDownloadCommand.NAME, "<cifex_file_id or cifex_link>");
            if (this.getArgs().size() != 1) {
                this.printHelp(true);
            }
            String fileIdStr = this.getArgs().get(0);
            try {
                this.fileID = Long.parseLong(fileIdStr);
            }
            catch (NumberFormatException numberFormatException) {
                Matcher fileIdLinkMatcher = FILE_ID_LINK_PATTERN.matcher(fileIdStr);
                if (fileIdLinkMatcher.find()) {
                    this.fileID = Long.parseLong(fileIdLinkMatcher.group(1));
                }
                this.printHelp(true);
            }
        }

        public File getDirectory() {
            if (this.directory == null) {
                return new File(".");
            }
            if (!this.directory.isDirectory()) {
                this.directory.mkdirs();
            }
            return this.directory;
        }

        public String getName() {
            if (this.isDecrypt() && this.name != null) {
                return String.valueOf(this.name) + ".pgp";
            }
            return this.name;
        }

        public String getClearName() {
            return this.name;
        }

        public boolean beQuiet() {
            return this.quiet;
        }

        public long getFileID() {
            return this.fileID;
        }

        public boolean isDecrypt() {
            return this.decrypt || this.passphrase != null;
        }

        public boolean isOverwriteOutputFile() {
            return this.overwriteOutputFile;
        }

        public String getPassphrase() {
            return this.passphrase;
        }
    }
}

