/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public class Utils {
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageUtil.class);

    public static BufferedImage loadUnchangedImage(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        String imageLibraryNameOrNull = null;
        String imageLibraryReaderNameOrNull = null;
        if (imageLibraryOrNull != null) {
            imageLibraryNameOrNull = imageLibraryOrNull.getName();
            imageLibraryReaderNameOrNull = imageLibraryOrNull.getReaderName();
        }
        return ImageUtil.loadUnchangedImage((IHierarchicalContentNode)contentNode, (String)imageIdOrNull, (String)imageLibraryNameOrNull, (String)imageLibraryReaderNameOrNull, null);
    }

    public static Size loadUnchangedImageSize(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        try {
            operationLog.debug((Object)("Trying to process file: " + contentNode.getRelativePath()));
        }
        catch (Exception exception) {}
        String imageLibraryNameOrNull = null;
        String imageLibraryReaderNameOrNull = null;
        if (imageLibraryOrNull != null) {
            imageLibraryNameOrNull = imageLibraryOrNull.getName();
            imageLibraryReaderNameOrNull = imageLibraryOrNull.getReaderName();
        }
        Dimension dimension = ImageUtil.loadUnchangedImageDimension((IHierarchicalContentNode)contentNode, (String)imageIdOrNull, (String)imageLibraryNameOrNull, imageLibraryReaderNameOrNull);
        return new Size(dimension.width, dimension.height);
    }

    public static int loadUnchangedImageColorDepth(IHierarchicalContentNode contentNode, String imageIdOrNull, ImageLibraryInfo imageLibraryOrNull) {
        try {
            operationLog.debug((Object)("Trying to process file: " + contentNode.getRelativePath()));
        }
        catch (Exception exception) {}
        String imageLibraryNameOrNull = null;
        String imageLibraryReaderNameOrNull = null;
        if (imageLibraryOrNull != null) {
            imageLibraryNameOrNull = imageLibraryOrNull.getName();
            imageLibraryReaderNameOrNull = imageLibraryOrNull.getReaderName();
        }
        return ImageUtil.loadUnchangedImageColorDepth((IHierarchicalContentNode)contentNode, (String)imageIdOrNull, (String)imageLibraryNameOrNull, imageLibraryReaderNameOrNull);
    }
}

