/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;
import java.util.Arrays;

public class ImageLine {
    public final ImageInfo imgInfo;
    final int channels;
    final int bitDepth;
    public final int[] scanline;
    private int rown = -1;

    public ImageLine(ImageInfo imgInfo) {
        this.imgInfo = imgInfo;
        this.channels = imgInfo.channels;
        this.scanline = new int[imgInfo.samplesPerRowP];
        this.bitDepth = imgInfo.bitDepth;
    }

    public int getRown() {
        return this.rown;
    }

    public void incRown() {
        ++this.rown;
    }

    public void setRown(int n) {
        this.rown = n;
    }

    public void setScanLine(int[] b) {
        System.arraycopy(b, 0, this.scanline, 0, this.scanline.length);
    }

    public int[] getScanLineCopy(int[] b) {
        if (b == null || b.length < this.scanline.length) {
            b = new int[this.scanline.length];
        }
        System.arraycopy(this.scanline, 0, b, 0, this.scanline.length);
        return b;
    }

    public int[] tf_unpack(int[] buf, boolean scale) {
        int len = this.scanline.length;
        if (this.bitDepth == 1) {
            len *= 8;
        } else if (this.bitDepth == 2) {
            len *= 4;
        } else if (this.bitDepth == 4) {
            len *= 2;
        }
        if (buf == null) {
            buf = new int[len];
        }
        if (this.bitDepth >= 8) {
            System.arraycopy(this.scanline, 0, buf, 0, this.scanline.length);
        } else {
            int mask0 = this.getMaskForPackedFormats();
            int offset0 = 8 - this.bitDepth;
            int mask = mask0;
            int offset = offset0;
            int i = 0;
            int j = 0;
            while (i < len) {
                int v = (this.scanline[j] & mask) >> offset;
                if (scale) {
                    v <<= offset0;
                }
                buf[i] = v;
                offset -= this.bitDepth;
                if ((mask >>= this.bitDepth) == 0) {
                    mask = mask0;
                    offset = offset0;
                    ++j;
                }
                ++i;
            }
        }
        return buf;
    }

    public void tf_pack(int[] buf, boolean scale) {
        int len = this.scanline.length;
        if (this.bitDepth == 1) {
            len *= 8;
        } else if (this.bitDepth == 2) {
            len *= 4;
        } else if (this.bitDepth == 4) {
            len *= 2;
        }
        if (this.bitDepth >= 8) {
            System.arraycopy(buf, 0, this.scanline, 0, this.scanline.length);
        } else {
            int offset0 = 8 - this.bitDepth;
            int mask0 = this.getMaskForPackedFormats() >> offset0;
            int offset = offset0;
            Arrays.fill(this.scanline, 0);
            int i = 0;
            int j = 0;
            while (i < len) {
                int v = buf[i];
                if (scale) {
                    v >>= offset0;
                }
                v = (v & mask0) << offset;
                int n = j++;
                this.scanline[n] = this.scanline[n] | v;
                if ((offset -= this.bitDepth) < 0) {
                    offset = offset0;
                }
                ++i;
            }
        }
    }

    private int getMaskForPackedFormats() {
        if (this.bitDepth == 1) {
            return 128;
        }
        if (this.bitDepth == 2) {
            return 192;
        }
        if (this.bitDepth == 4) {
            return 240;
        }
        throw new RuntimeException("?");
    }

    public String toString() {
        return "row=" + this.rown + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.scanline.length;
    }

    public static void showLineInfo(ImageLine line) {
        System.out.println(line);
        ImageLineHelper.ImageLineStats stats = new ImageLineHelper.ImageLineStats(line);
        System.out.println(stats);
        System.out.println(ImageLineHelper.infoFirstLastPixels(line));
    }
}

