/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.AuthorizationService;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SearchService;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IAggregationServiceReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IDbModifyingAggregationServiceReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IProcessingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.MailService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IDataSet;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IMailService;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.IDataSourceQueryService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.ISessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.authorization.IAuthorizationService;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PluginScriptRunnerFactory
implements IPluginScriptRunnerFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PluginScriptRunnerFactory.class);
    private static final String SEARCH_SERVICE_VARIABLE_NAME = "searchService";
    private static final String SEARCH_SERVICE_UNFILTERED_VARIABLE_NAME = "searchServiceUnfiltered";
    private static final String DATA_SOURCE_QUERY_SERVICE_VARIABLE_NAME = "queryService";
    private static final String MAIL_SERVICE_VARIABLE_NAME = "mailService";
    private static final String AUTHORIZATION_SERVICE = "authorizationService";
    private static final String CONTENT_PROVIDER_VARIABLE_NAME = "contentProvider";
    private static final String CONTENT_PROVIDER_UNFILTERED_VARIABLE_NAME = "contentProviderUnfiltered";
    private static final String SESSION_WORKSPACE_PROVIDER_NAME = "sessionWorkspaceProvider";
    private static final String USER_ID = "userId";
    private final String scriptPath;

    public PluginScriptRunnerFactory(String scriptPath) {
        this.scriptPath = scriptPath;
        Evaluator.initialize();
    }

    @Override
    public IAggregationServiceReportingPluginScriptRunner createAggregationServiceReportingPluginRunner(DataSetProcessingContext context) {
        String scriptString = PluginScriptRunnerFactory.extractScriptFromPath(this.scriptPath);
        try {
            AbstractAggregationServiceReportingPluginScriptRunner.InputData inputData = this.createInputDataForReportingPluginScriptRunner(context, scriptString);
            return new AggregationServiceReportingPluginScriptRunner(inputData);
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(String.valueOf(ex.getMessage()) + " [" + this.scriptPath + "]");
        }
    }

    @Override
    public IDbModifyingAggregationServiceReportingPluginScriptRunner createDbModifyingAggregationServiceReportingPluginRunner(DataSetProcessingContext context) {
        String scriptString = PluginScriptRunnerFactory.extractScriptFromPath(this.scriptPath);
        try {
            AbstractAggregationServiceReportingPluginScriptRunner.InputData inputData = this.createInputDataForReportingPluginScriptRunner(context, scriptString);
            return new DbModifyingAggregationServiceReportingPluginScriptRunner(inputData);
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(String.valueOf(ex.getMessage()) + " [" + this.scriptPath + "]");
        }
    }

    private AbstractAggregationServiceReportingPluginScriptRunner.InputData createInputDataForReportingPluginScriptRunner(DataSetProcessingContext context, String scriptString) {
        Evaluator evaluator = this.createEvaluator(scriptString, context);
        DataSetContentProvider contentProvider = new DataSetContentProvider(context.getHierarchicalContentProvider());
        evaluator.set(CONTENT_PROVIDER_VARIABLE_NAME, contentProvider);
        DataSetContentProvider contentProviderUnfiltered = new DataSetContentProvider(context.getHierarchicalContentProviderUnfiltered());
        evaluator.set(CONTENT_PROVIDER_UNFILTERED_VARIABLE_NAME, contentProviderUnfiltered);
        AbstractAggregationServiceReportingPluginScriptRunner.InputData inputData = new AbstractAggregationServiceReportingPluginScriptRunner.InputData(evaluator, contentProvider, contentProviderUnfiltered);
        return inputData;
    }

    @Override
    public IReportingPluginScriptRunner createReportingPluginRunner(DataSetProcessingContext context) {
        String scriptString = PluginScriptRunnerFactory.extractScriptFromPath(this.scriptPath);
        try {
            return new ReportingPluginScriptRunner(this.createEvaluator(scriptString, context));
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(String.valueOf(ex.getMessage()) + " [" + this.scriptPath + "]");
        }
    }

    @Override
    public IProcessingPluginScriptRunner createProcessingPluginRunner(DataSetProcessingContext context) {
        String scriptString = PluginScriptRunnerFactory.extractScriptFromPath(this.scriptPath);
        try {
            return new ProcessingPluginScriptRunner(this.createEvaluator(scriptString, context));
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(String.valueOf(ex.getMessage()) + " [" + this.scriptPath + "]");
        }
    }

    static String extractScriptFromPath(String scriptPath) throws EvaluatorException {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            throw new EvaluatorException("Plugin script [" + scriptPath + "] specified in the configuration doesn't exist.");
        }
        String scriptString = FileUtilities.loadToString(scriptFile);
        if (StringUtils.isBlank(scriptString)) {
            throw new EvaluatorException("Plugin script [" + scriptPath + "] specified in the configuration is empty.");
        }
        try {
            return String.valueOf(scriptString) + "\n";
        }
        catch (EvaluatorException ex) {
            throw new EvaluatorException(String.valueOf(ex.getMessage()) + " [" + scriptPath + "]");
        }
    }

    protected Evaluator createEvaluator(String scriptString, DataSetProcessingContext context) {
        Evaluator evaluator = new Evaluator("", null, scriptString, false);
        evaluator.set(SEARCH_SERVICE_VARIABLE_NAME, this.createUserSearchService(context));
        evaluator.set(SEARCH_SERVICE_UNFILTERED_VARIABLE_NAME, this.createUnfilteredSearchService());
        evaluator.set(MAIL_SERVICE_VARIABLE_NAME, PluginScriptRunnerFactory.createMailService(context));
        evaluator.set(DATA_SOURCE_QUERY_SERVICE_VARIABLE_NAME, this.createDataSourceQueryService());
        evaluator.set(AUTHORIZATION_SERVICE, this.createAuthorizationService());
        evaluator.set(USER_ID, context.getUserId());
        ISessionWorkspaceProvider workspaceProvider = context.tryGetSessionWorkspaceProvider();
        if (workspaceProvider != null) {
            evaluator.set(SESSION_WORKSPACE_PROVIDER_NAME, workspaceProvider);
        }
        return evaluator;
    }

    protected ISearchService createUserSearchService(DataSetProcessingContext context) {
        if (context.getUserId() == null) {
            return this.createUnfilteredSearchService();
        }
        return new SearchService(ServiceProvider.getOpenBISService().getBasicFilteredOpenBISService(context.getUserId()));
    }

    protected ISearchService createUnfilteredSearchService() {
        return new SearchService(ServiceProvider.getOpenBISService());
    }

    protected IAuthorizationService createAuthorizationService() {
        return new AuthorizationService(ServiceProvider.getOpenBISService());
    }

    protected IDataSourceQueryService createDataSourceQueryService() {
        return new DataSourceQueryService();
    }

    private static IMailService createMailService(DataSetProcessingContext context) {
        return new MailService(context.getMailClient(), context.getUserEmailOrNull());
    }

    @Override
    public String getScriptPath() {
        return this.scriptPath;
    }

    private static abstract class AbstractAggregationServiceReportingPluginScriptRunner {
        final Evaluator evaluator;
        final DataSetContentProvider[] contentProviders;

        protected abstract String getFunctionName();

        public AbstractAggregationServiceReportingPluginScriptRunner(InputData inputData) {
            this.evaluator = inputData.evaluator;
            this.contentProviders = inputData.contentProviders;
            if (!this.evaluator.hasFunction(this.getFunctionName())) {
                throw new EvaluatorException("Function '" + this.getFunctionName() + "' was not defined in the reporting plugin script");
            }
        }

        public void releaseResources() {
            DataSetContentProvider[] dataSetContentProviderArray = this.contentProviders;
            int n = this.contentProviders.length;
            int n2 = 0;
            while (n2 < n) {
                DataSetContentProvider contentProvider = dataSetContentProviderArray[n2];
                contentProvider.closeContents();
                ++n2;
            }
            this.evaluator.releaseResources();
        }

        static class InputData {
            private final Evaluator evaluator;
            private final DataSetContentProvider[] contentProviders;

            public InputData(Evaluator evaluator, DataSetContentProvider ... contentProviders) {
                this.evaluator = evaluator;
                this.contentProviders = contentProviders;
            }
        }
    }

    private static class AggregationServiceReportingPluginScriptRunner
    extends AbstractAggregationServiceReportingPluginScriptRunner
    implements IAggregationServiceReportingPluginScriptRunner {
        private static final String FUNCTION_NAME = "aggregate";

        @Override
        protected String getFunctionName() {
            return FUNCTION_NAME;
        }

        AggregationServiceReportingPluginScriptRunner(AbstractAggregationServiceReportingPluginScriptRunner.InputData inputData) {
            super(inputData);
        }

        @Override
        public void aggregate(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor tableBuilder) throws EvaluatorException {
            this.evaluator.evalFunction(FUNCTION_NAME, parameters, tableBuilder);
        }
    }

    private static final class DataSetContentProvider
    implements IDataSetContentProvider {
        private final IHierarchicalContentProvider contentProvider;
        private final Map<String, IHierarchicalContent> contents = new HashMap<String, IHierarchicalContent>();

        public DataSetContentProvider(IHierarchicalContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        @Override
        public IHierarchicalContent getContent(String dataSetCode) {
            IHierarchicalContent content = this.contents.get(dataSetCode);
            if (content == null) {
                content = this.contentProvider.asContent(dataSetCode);
                this.contents.put(dataSetCode, content);
            }
            return content;
        }

        public void closeContents() {
            for (IHierarchicalContent content : this.contents.values()) {
                content.close();
            }
        }
    }

    private static class DbModifyingAggregationServiceReportingPluginScriptRunner
    extends AbstractAggregationServiceReportingPluginScriptRunner
    implements IDbModifyingAggregationServiceReportingPluginScriptRunner {
        private static final String FUNCTION_NAME = "process";

        DbModifyingAggregationServiceReportingPluginScriptRunner(AbstractAggregationServiceReportingPluginScriptRunner.InputData inputData) {
            super(inputData);
        }

        @Override
        protected String getFunctionName() {
            return FUNCTION_NAME;
        }

        @Override
        public void process(IDataSetRegistrationTransactionV2 transaction, Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor tableBuilder) throws EvaluatorException {
            this.evaluator.evalFunction(FUNCTION_NAME, transaction, parameters, tableBuilder);
        }
    }

    private static class ProcessingPluginScriptRunner
    implements IProcessingPluginScriptRunner {
        private static final String PROCESS_FUNCTION_NAME = "process";
        private final Evaluator evaluator;

        ProcessingPluginScriptRunner(Evaluator evaluator) {
            this.evaluator = evaluator;
            if (!evaluator.hasFunction(PROCESS_FUNCTION_NAME)) {
                throw new EvaluatorException("Function 'process' was not defined in the processing plugin script");
            }
        }

        @Override
        public Status process(IDataSet dataSet) {
            try {
                this.evaluator.evalFunction(PROCESS_FUNCTION_NAME, dataSet);
            }
            catch (EvaluatorException ex) {
                operationLog.error((Object)ex.getMessage());
                return Status.createError(ex.getMessage());
            }
            return Status.OK;
        }

        @Override
        public void releaseResources() {
            this.evaluator.releaseResources();
        }
    }

    private static class ReportingPluginScriptRunner
    implements IReportingPluginScriptRunner {
        private static final String DESCRIBE_FUNCTION_NAME = "describe";
        private final Evaluator evaluator;

        ReportingPluginScriptRunner(Evaluator evaluator) {
            this.evaluator = evaluator;
            if (!evaluator.hasFunction(DESCRIBE_FUNCTION_NAME)) {
                throw new EvaluatorException("Function 'describe' was not defined in the reporting plugin script");
            }
        }

        @Override
        public void describe(List<IDataSet> dataSets, ISimpleTableModelBuilderAdaptor tableBuilder) {
            this.evaluator.evalFunction(DESCRIBE_FUNCTION_NAME, dataSets, tableBuilder);
        }

        @Override
        public void releaseResources() {
            this.evaluator.releaseResources();
        }
    }
}

