/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDatastorePlugin
implements Serializable {
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractDatastorePlugin.class);
    private static final String SUB_DIRECTORY_NAME = "sub-directory-name";
    private static final long serialVersionUID = 1L;
    protected final File storeRoot;
    private final String subDirectory;
    protected final Properties properties;

    protected AbstractDatastorePlugin(Properties properties, File storeRoot) {
        this(properties, storeRoot, null);
    }

    protected AbstractDatastorePlugin(Properties properties, File storeRoot, String subDirectoryOrNull) {
        if (!storeRoot.exists()) {
            throw ConfigurationFailureException.fromTemplate("Store root '%s' does not exist.", storeRoot);
        }
        this.storeRoot = storeRoot;
        this.properties = properties;
        this.subDirectory = subDirectoryOrNull == null ? properties.getProperty(SUB_DIRECTORY_NAME, "original") : subDirectoryOrNull;
    }

    @Deprecated
    protected File getDataSubDir(IDataSetDirectoryProvider provider, DatasetDescription dataset) {
        if (StringUtils.isBlank((String)this.subDirectory)) {
            return this.getDatasetDir(provider, dataset);
        }
        return new File(this.getDatasetDir(provider, dataset), this.subDirectory);
    }

    protected File getDatasetDir(IDataSetDirectoryProvider provider, DatasetDescription dataset) {
        return provider.getDataSetDirectory(dataset);
    }

    protected IHierarchicalContentNode getDataSubDir(IHierarchicalContentProvider provider, DatasetDescription dataset) {
        if (StringUtils.isBlank((String)this.subDirectory)) {
            return this.getDatasetDir(provider, dataset).getRootNode();
        }
        return this.getDatasetDir(provider, dataset).getNode(this.subDirectory);
    }

    protected IHierarchicalContent getDatasetDir(IHierarchicalContentProvider provider, DatasetDescription dataset) {
        return provider.asContent(dataset.getDataSetCode());
    }

    protected IHierarchicalContentNode getDataSubDir(IHierarchicalContentProvider provider, String dataSetCode) {
        if (StringUtils.isBlank((String)this.subDirectory)) {
            return this.getDatasetDir(provider, dataSetCode).getRootNode();
        }
        return this.getDatasetDir(provider, dataSetCode).getNode(this.subDirectory);
    }

    protected IHierarchicalContent getDatasetDir(IHierarchicalContentProvider provider, String dataSetCode) {
        return provider.asContent(dataSetCode);
    }
}

