/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.common.ssl.SslCertificateHelper;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.DssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IContentCache;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.IDssServiceRpcGenericFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.PathInfoDBAwareHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.content.RemoteHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.PathInfoDataSourceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class HierarchicalContentProvider
implements IHierarchicalContentProvider {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, HierarchicalContentProvider.class);
    private final IEncapsulatedOpenBISService openbisService;
    private final IDataSetDirectoryProvider directoryProvider;
    private IHierarchicalContentFactory hierarchicalContentFactory;
    private final ISessionTokenProvider sessionTokenProvider;
    private final String dataStoreCode;
    private final boolean trustAllCertificates;
    private final IContentCache cache;
    private final IDssServiceRpcGenericFactory serviceFactory;

    public HierarchicalContentProvider(IEncapsulatedOpenBISService openbisService, IShareIdManager shareIdManager, IConfigProvider configProvider, IContentCache contentCache, ISessionTokenProvider sessionTokenProvider, ExposablePropertyPlaceholderConfigurer infoProvider) {
        this(openbisService, (IDataSetDirectoryProvider)new DataSetDirectoryProvider(configProvider.getStoreRoot(), shareIdManager), null, (IDssServiceRpcGenericFactory)new DssServiceRpcGenericFactory(), contentCache, sessionTokenProvider, configProvider.getDataStoreCode(), infoProvider);
    }

    public HierarchicalContentProvider(IEncapsulatedOpenBISService openbisService, IShareIdManager shareIdManager, IConfigProvider configProvider, IContentCache contentCache, IHierarchicalContentFactory hierarchicalContentFactory, IDssServiceRpcGenericFactory serviceFactory, ISessionTokenProvider sessionTokenProvider, ExposablePropertyPlaceholderConfigurer infoProvider) {
        this(openbisService, (IDataSetDirectoryProvider)new DataSetDirectoryProvider(configProvider.getStoreRoot(), shareIdManager), hierarchicalContentFactory, serviceFactory, contentCache, sessionTokenProvider, configProvider.getDataStoreCode(), infoProvider);
    }

    @Private
    public HierarchicalContentProvider(IEncapsulatedOpenBISService openbisService, IDataSetDirectoryProvider directoryProvider, IHierarchicalContentFactory hierarchicalContentFactory, IDssServiceRpcGenericFactory serviceFactory, IContentCache contentCache, ISessionTokenProvider sessionTokenProvider, String dataStoreCode, ExposablePropertyPlaceholderConfigurer infoProvider) {
        this(openbisService, directoryProvider, hierarchicalContentFactory, serviceFactory, contentCache, sessionTokenProvider, dataStoreCode, infoProvider != null && "true".equalsIgnoreCase(infoProvider.getResolvedProps().getProperty("trust-all-certificates")));
    }

    private HierarchicalContentProvider(IEncapsulatedOpenBISService openbisService, IDataSetDirectoryProvider directoryProvider, IHierarchicalContentFactory hierarchicalContentFactory, IDssServiceRpcGenericFactory serviceFactory, IContentCache contentCache, ISessionTokenProvider sessionTokenProvider, String dataStoreCode, boolean trustAllCertificates) {
        this.openbisService = openbisService;
        this.directoryProvider = directoryProvider;
        this.hierarchicalContentFactory = hierarchicalContentFactory;
        this.serviceFactory = serviceFactory;
        this.cache = contentCache;
        this.sessionTokenProvider = sessionTokenProvider;
        this.dataStoreCode = dataStoreCode;
        this.trustAllCertificates = trustAllCertificates;
    }

    @Override
    public IHierarchicalContentProvider cloneFor(ISessionTokenProvider anotherSessionTokenProvider) {
        return new HierarchicalContentProvider(this.openbisService, this.directoryProvider, this.hierarchicalContentFactory, this.serviceFactory, this.cache, anotherSessionTokenProvider, this.dataStoreCode, this.trustAllCertificates);
    }

    @Override
    public IHierarchicalContent asContent(String dataSetCode) {
        IDatasetLocationNode locationNode = this.openbisService.tryGetDataSetLocation(dataSetCode);
        if (locationNode == null) {
            operationLog.error((Object)String.format("Data set '%s' not found in openBIS server.", dataSetCode));
            throw new IllegalArgumentException("Unknown data set: " + dataSetCode);
        }
        return this.asContent(locationNode);
    }

    @Override
    public IHierarchicalContent asContent(AbstractExternalData dataSet) {
        return this.asContent(new ExternalDataLocationNode(dataSet));
    }

    private IHierarchicalContent asContent(IDatasetLocationNode locationNode) {
        if (this.isLocal(locationNode)) {
            if (locationNode.isContainer()) {
                ArrayList<IHierarchicalContent> componentContents = new ArrayList<IHierarchicalContent>();
                for (IDatasetLocationNode component : locationNode.getComponents()) {
                    IHierarchicalContent componentContent = this.tryCreateComponentContent(component);
                    if (componentContent == null) continue;
                    componentContents.add(componentContent);
                }
                return this.getHierarchicalContentFactory().asVirtualHierarchicalContent(componentContents);
            }
            return this.asContent(locationNode.getLocation());
        }
        ISingleDataSetPathInfoProvider provider = null;
        if (PathInfoDataSourceProvider.isDataSourceDefined()) {
            IDataSetPathInfoProvider dataSetPathInfoProvider = ServiceProvider.getDataSetPathInfoProvider();
            provider = dataSetPathInfoProvider.tryGetSingleDataSetPathInfoProvider(locationNode.getLocation().getDataSetCode());
        }
        if (this.trustAllCertificates) {
            SslCertificateHelper.trustAnyCertificate(locationNode.getLocation().getDataStoreUrl());
        }
        return new RemoteHierarchicalContent(locationNode, provider, this.serviceFactory, this.sessionTokenProvider, this.cache);
    }

    private boolean isLocal(IDatasetLocationNode node) {
        return this.dataStoreCode.equals(node.getLocation().getDataStoreCode());
    }

    private IHierarchicalContent tryCreateComponentContent(IDatasetLocationNode componentLocationNode) {
        try {
            if (componentLocationNode.isContainer()) {
                return this.asContent(componentLocationNode);
            }
            return this.asContent(componentLocationNode.getLocation());
        }
        catch (IllegalArgumentException ex) {
            operationLog.info((Object)("ignoring contained data set " + componentLocationNode.getLocation().getDataSetCode() + ": " + ex.getMessage()));
            return null;
        }
    }

    @Override
    public IHierarchicalContent asContent(final IDatasetLocation datasetLocation) {
        this.directoryProvider.getShareIdManager().lock(datasetLocation.getDataSetCode());
        File dataSetDirectory = this.directoryProvider.getDataSetDirectory(datasetLocation);
        IDelegatedAction onCloseAction = new IDelegatedAction(){

            @Override
            public void execute() {
                HierarchicalContentProvider.this.directoryProvider.getShareIdManager().releaseLock(datasetLocation.getDataSetCode());
            }
        };
        return this.asContent(dataSetDirectory, onCloseAction);
    }

    @Override
    public IHierarchicalContent asContent(File dataSetDirectory) {
        return this.getHierarchicalContentFactory().asHierarchicalContent(dataSetDirectory, IDelegatedAction.DO_NOTHING);
    }

    public IHierarchicalContent asContent(File dataSetDirectory, IDelegatedAction onCloseAction) {
        try {
            return this.getHierarchicalContentFactory().asHierarchicalContent(dataSetDirectory, onCloseAction);
        }
        catch (RuntimeException ex) {
            onCloseAction.execute();
            throw ex;
        }
    }

    private IHierarchicalContentFactory getHierarchicalContentFactory() {
        if (this.hierarchicalContentFactory == null) {
            this.hierarchicalContentFactory = PathInfoDBAwareHierarchicalContentFactory.create();
        }
        return this.hierarchicalContentFactory;
    }
}

