/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.DefaultSessionManager;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.ILogMessagePrefixGenerator;
import ch.systemsx.cisd.authentication.ISessionFactory;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.Map;

public class OpenBisSessionManager
extends DefaultSessionManager<Session>
implements IOpenBisSessionManager {
    IDAOFactory daoFactory;

    public OpenBisSessionManager(ISessionFactory<Session> sessionFactory, ILogMessagePrefixGenerator<Session> prefixGenerator, IAuthenticationService authenticationService, IRemoteHostProvider remoteHostProvider, int sessionExpirationPeriodMinutes, boolean tryEmailAsUserName, IDAOFactory daoFactory) {
        super(sessionFactory, prefixGenerator, authenticationService, remoteHostProvider, sessionExpirationPeriodMinutes, tryEmailAsUserName);
        this.daoFactory = daoFactory;
    }

    public OpenBisSessionManager(ISessionFactory<Session> sessionFactory, ILogMessagePrefixGenerator<Session> prefixGenerator, IAuthenticationService authenticationService, IRemoteHostProvider remoteHostProvider, int sessionExpirationPeriodMinutes, IDAOFactory daoFactory) {
        super(sessionFactory, prefixGenerator, authenticationService, remoteHostProvider, sessionExpirationPeriodMinutes);
        this.daoFactory = daoFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllSessions() {
        Map map = this.sessions;
        synchronized (map) {
            for (DefaultSessionManager.FullSession fullSession : this.sessions.values()) {
                Session session;
                Session session2 = session = (Session)fullSession.getSession();
                synchronized (session2) {
                    IPersonDAO personDAO;
                    PersonPE person;
                    PersonPE oldPerson = session.tryGetPerson();
                    if (oldPerson != null && !oldPerson.isSystemUser() && (person = (PersonPE)(personDAO = this.daoFactory.getPersonDAO()).tryGetByTechId(new TechId(oldPerson.getId()), new String[0])) != null) {
                        HibernateUtils.initialize(person.getAllPersonRoles());
                        session.setPerson(person);
                    }
                }
            }
        }
    }
}

