/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.MDC;

public final class LoggingContextHandler {
    private static final String MDC_KEY = "contextInfo";
    private final Map<String, String> loggingContextMap = new HashMap<String, String>();
    private final IRemoteHostProvider remoteHostProvider;

    public LoggingContextHandler(IRemoteHostProvider remoteHostProvider) {
        this.remoteHostProvider = remoteHostProvider;
    }

    public void addContext(String contextID, String context) {
        this.loggingContextMap.put(contextID, context);
    }

    public final void destroyContext(String contextID) {
        this.loggingContextMap.remove(contextID);
    }

    public final void setMDC(String contextID) {
        String context = this.loggingContextMap.get(contextID);
        String remoteHost = this.remoteHostProvider.getRemoteHost();
        if (context == null) {
            MDC.put((String)MDC_KEY, (Object)String.format(" {UNKNOWN_TOKEN='%s', ip=%s}", contextID, remoteHost));
        } else {
            MDC.put((String)MDC_KEY, (Object)String.format(" {%s, ip=%s}", context, remoteHost));
        }
    }
}

