/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomAccessInputStream
extends InputStream
implements DataInput {
    protected static final int MAX_OVERHEAD = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomAccessInputStream.class);
    protected static final int DEFAULT_BLOCK_SIZE = 262144;
    protected static final int MAX_SEARCH_SIZE = 0x20000000;
    protected IRandomAccess raf;
    protected final String file;
    protected long length = -1L;
    protected long markedPos = -1L;
    protected String encoding = "UTF-8";

    public RandomAccessInputStream(String file2) throws IOException {
        this(Location.getHandle(file2), file2);
    }

    public RandomAccessInputStream(IRandomAccess handle) throws IOException {
        this(handle, null);
    }

    public RandomAccessInputStream(IRandomAccess handle, String file2) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("RandomAccessInputStream {} OPEN", this.hashCode());
        }
        this.raf = handle;
        this.raf.setOrder(ByteOrder.BIG_ENDIAN);
        this.file = file2;
        this.seek(0L);
        this.length = -1L;
    }

    public RandomAccessInputStream(byte[] array) throws IOException {
        this(new ByteArrayHandle(array));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public long length() throws IOException {
        return this.length < 0L ? this.raf.length() : this.length;
    }

    public void setLength(long newLength) throws IOException {
        if (newLength < this.length()) {
            this.length = newLength;
        }
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public void close() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("RandomAccessInputStream {} CLOSE", this.hashCode());
        }
        if (Location.getMappedFile(this.file) != null) {
            return;
        }
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
        this.markedPos = -1L;
    }

    public void order(boolean little) {
        if (this.raf != null) {
            this.raf.setOrder(little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
    }

    public boolean isLittleEndian() {
        return this.raf.getOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    public String readString(String lastChars) throws IOException {
        if (lastChars.length() == 1) {
            return this.findString(lastChars);
        }
        String[] terminators = new String[lastChars.length()];
        for (int i = 0; i < terminators.length; ++i) {
            terminators[i] = lastChars.substring(i, i + 1);
        }
        return this.findString(terminators);
    }

    public String findString(String ... terminators) throws IOException {
        return this.findString(true, 262144, terminators);
    }

    public String findString(boolean saveString, String ... terminators) throws IOException {
        return this.findString(saveString, 262144, terminators);
    }

    public String findString(int blockSize, String ... terminators) throws IOException {
        return this.findString(true, blockSize, terminators);
    }

    public String findString(boolean saveString, int blockSize, String ... terminators) throws IOException {
        int r;
        boolean tooLong;
        StringBuilder out = new StringBuilder();
        long startPos = this.getFilePointer();
        long bytesDropped = 0L;
        long inputLen = this.length();
        long maxLen = inputLen - startPos;
        boolean bl = tooLong = saveString && maxLen > 0x20000000L;
        if (tooLong) {
            maxLen = 0x20000000L;
        }
        boolean match = false;
        int maxTermLen = 0;
        for (String term : terminators) {
            int len = term.length();
            if (len <= maxTermLen) continue;
            maxTermLen = len;
        }
        InputStreamReader in = new InputStreamReader((InputStream)this, this.encoding);
        char[] buf = new char[blockSize];
        for (long loc = 0L; loc < maxLen && this.getFilePointer() < this.length() - 1L; loc += (long)r) {
            int outLen;
            if (!saveString && (outLen = out.length()) >= maxTermLen) {
                int dropIndex = outLen - maxTermLen + 1;
                String last = out.substring(dropIndex, outLen);
                out.setLength(0);
                out.append(last);
                bytesDropped += (long)dropIndex;
            }
            if ((r = in.read(buf, 0, blockSize)) <= 0) {
                throw new IOException("Cannot read from stream: " + r);
            }
            out.append(buf, 0, r);
            int min = Integer.MAX_VALUE;
            int tagLen = 0;
            String[] arr$ = terminators;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String t;
                int len = (t = arr$[i$]).length();
                int start = (int)(loc - bytesDropped - (long)len);
                int value = out.indexOf(t, start < 0 ? 0 : start);
                if (value < 0 || value >= min) continue;
                match = true;
                min = value;
                tagLen = len;
            }
            if (!match) continue;
            this.seek(startPos + bytesDropped + (long)min + (long)tagLen);
            if (saveString) {
                out.setLength(min + tagLen);
                return out.toString();
            }
            return null;
        }
        if (tooLong) {
            throw new IOException("Maximum search length reached.");
        }
        return saveString ? out.toString() : null;
    }

    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    public String readLine() throws IOException {
        String line = this.findString("\n");
        return line.length() == 0 ? null : line;
    }

    public String readCString() throws IOException {
        String line = this.findString("\u0000");
        return line.length() == 0 ? null : line;
    }

    public String readString(int n) throws IOException {
        int avail = this.available();
        if (n > avail) {
            n = avail;
        }
        byte[] b = new byte[n];
        this.readFully(b);
        return new String(b, this.encoding);
    }

    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    public int read(byte[] array) throws IOException {
        int rtn = this.raf.read(array);
        if (rtn == 0 && this.raf.getFilePointer() >= this.raf.length() - 1L) {
            rtn = -1;
        }
        return rtn;
    }

    public int read(byte[] array, int offset, int n) throws IOException {
        int rtn = this.raf.read(array, offset, n);
        if (rtn == 0 && this.raf.getFilePointer() >= this.raf.length() - 1L) {
            rtn = -1;
        }
        return rtn;
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.raf.read(buf);
    }

    public int read(ByteBuffer buf, int offset, int n) throws IOException {
        return this.raf.read(buf, offset, n);
    }

    public void readFully(byte[] array) throws IOException {
        this.raf.readFully(array);
    }

    public void readFully(byte[] array, int offset, int n) throws IOException {
        this.raf.readFully(array, offset, n);
    }

    public int read() throws IOException {
        byte b = this.readByte();
        if (b == -1 && this.getFilePointer() >= this.length()) {
            return 0;
        }
        return b;
    }

    public int available() throws IOException {
        long remain = this.length() - this.getFilePointer();
        if (remain > Integer.MAX_VALUE) {
            remain = Integer.MAX_VALUE;
        }
        return (int)remain;
    }

    public void mark(int readLimit) {
        try {
            this.markedPos = this.getFilePointer();
        }
        catch (IOException exc) {
            LOGGER.warn("Cannot set mark", exc);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        if (this.markedPos < 0L) {
            throw new IOException("No mark set");
        }
        this.seek(this.markedPos);
    }
}

