/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Hashtable;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEGTileDecoder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JPEGTileDecoder.class);
    private TileConsumer consumer;
    private TileCache tiles;
    private RandomAccessInputStream in;

    public void initialize(String id, int imageWidth) {
        try {
            this.initialize(new RandomAccessInputStream(id), imageWidth);
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
    }

    public void initialize(RandomAccessInputStream in, int imageWidth) {
        this.initialize(in, 0, 0, imageWidth);
    }

    public void initialize(RandomAccessInputStream in, int y, int h, int imageWidth) {
        this.in = in;
        this.tiles = new TileCache(y, h);
        try {
            long fp = in.getFilePointer();
            boolean littleEndian = in.isLittleEndian();
            in.order(false);
            while (in.getFilePointer() < in.length() - 1L) {
                int code = in.readShort() & 0xFFFF;
                int length = in.readShort() & 0xFFFF;
                long pointer = in.getFilePointer();
                if (length > 65280 || code < 65280) {
                    in.seek(pointer - 3L);
                    continue;
                }
                if (code == 65472) {
                    in.skipBytes(1);
                    int height = in.readShort() & 0xFFFF;
                    int width = in.readShort() & 0xFFFF;
                    if (height != 0 && width != 0) break;
                    throw new RuntimeException("Width or height > 65500 is not supported.");
                }
                if (pointer + (long)length - 2L >= in.length()) break;
                in.seek(pointer + (long)length - 2L);
            }
            in.seek(fp);
            in.order(littleEndian);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            byte[] data = new byte[this.in.available()];
            this.in.readFully(data);
            Image image = toolkit.createImage(data);
            ImageProducer producer = image.getSource();
            this.consumer = new TileConsumer(producer, y, h);
            producer.startProduction(this.consumer);
            while (producer.isConsumer(this.consumer)) {
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public byte[] getScanline(int y) {
        try {
            return this.tiles.get(0, y, this.consumer.getWidth(), 1);
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
        return null;
    }

    public int getWidth() {
        return this.consumer.getWidth();
    }

    public int getHeight() {
        return this.consumer.getHeight();
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("", e);
        }
        this.tiles = null;
        this.consumer = null;
    }

    class TileCache {
        private static final int ROW_COUNT = 128;
        private Hashtable<Region, byte[]> compressedTiles = new Hashtable();
        private JPEGCodec codec = new JPEGCodec();
        private CodecOptions options = new CodecOptions();
        private ByteVector toCompress = new ByteVector();
        private int row = 0;
        private Region lastRegion = null;
        private byte[] lastTile = null;
        private int yy = 0;
        private int hh = 0;

        public TileCache(int yy, int hh) {
            this.options.interleaved = true;
            this.options.littleEndian = false;
            this.yy = yy;
            this.hh = hh;
        }

        public void add(byte[] pixels, int x, int y, int w, int h) throws FormatException, IOException {
            this.toCompress.add(pixels);
            ++this.row;
            if (y % 128 == 127 || y == JPEGTileDecoder.this.getHeight() - 1 || y == this.yy + this.hh - 1) {
                Region r = new Region(x, y - this.row + 1, w, this.row);
                this.options.width = w;
                this.options.height = this.row;
                this.options.channels = 1;
                this.options.bitsPerSample = 8;
                this.options.signed = false;
                byte[] compressed = this.codec.compress(this.toCompress.toByteArray(), this.options);
                this.compressedTiles.put(r, compressed);
                this.toCompress.clear();
            }
        }

        public void add(int[] pixels, int x, int y, int w, int h) throws FormatException, IOException {
            byte[] buf = new byte[pixels.length * 3];
            for (int i = 0; i < pixels.length; ++i) {
                buf[i * 3] = (byte)((pixels[i] & 0xFF0000) >> 16);
                buf[i * 3 + 1] = (byte)((pixels[i] & 0xFF00) >> 8);
                buf[i * 3 + 2] = (byte)(pixels[i] & 0xFF);
            }
            this.toCompress.add(buf);
            ++this.row;
            if (y % 128 == 127 || y == JPEGTileDecoder.this.getHeight() - 1 || y == this.yy + this.hh - 1) {
                Region r = new Region(x, y - this.row + 1, w, this.row);
                this.options.width = w;
                this.options.height = this.row;
                this.options.channels = 3;
                this.options.bitsPerSample = 8;
                this.options.signed = false;
                byte[] compressed = this.codec.compress(this.toCompress.toByteArray(), this.options);
                this.compressedTiles.put(r, compressed);
                this.toCompress.clear();
                this.row = 0;
            }
        }

        public byte[] get(int x, int y, int w, int h) throws FormatException, IOException {
            Region[] keys = this.compressedTiles.keySet().toArray(new Region[0]);
            Region r = new Region(x, y, w, h);
            for (Region key : keys) {
                if (!key.intersects(r)) continue;
                r = key;
            }
            if (!r.equals(this.lastRegion)) {
                this.lastRegion = r;
                byte[] compressed = null;
                compressed = this.compressedTiles.get(r);
                if (compressed == null) {
                    return null;
                }
                this.lastTile = this.codec.decompress(compressed, this.options);
            }
            int pixel = this.options.channels * (this.options.bitsPerSample / 8);
            byte[] buf = new byte[w * h * pixel];
            for (int i = 0; i < h; ++i) {
                System.arraycopy(this.lastTile, r.width * pixel * (i + y - r.y) + (x - r.x), buf, i * w * pixel, pixel * w);
            }
            return buf;
        }
    }

    class TileConsumer
    implements ImageConsumer {
        private int width;
        private int height;
        private ImageProducer producer;
        private int yy = 0;
        private int hh = 0;

        public TileConsumer(ImageProducer producer) {
            this.producer = producer;
        }

        public TileConsumer(ImageProducer producer, int y, int h) {
            this(producer);
            this.yy = y;
            this.hh = h;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void imageComplete(int status) {
            this.producer.removeConsumer(this);
        }

        public void setDimensions(int width, int height) {
            this.width = width;
            this.height = height;
            if (this.hh <= 0) {
                this.hh = height;
            }
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scanSize) {
            LOGGER.debug("Storing row {} of {} ({}%)", new Object[]{y, this.height, (double)y / (double)this.height * 100.0});
            if (y >= this.yy + this.hh) {
                this.imageComplete(0);
                return;
            }
            if (y < this.yy) {
                return;
            }
            try {
                JPEGTileDecoder.this.tiles.add(pixels, x, y, w, h);
            }
            catch (FormatException e) {
                LOGGER.debug("", e);
            }
            catch (IOException e) {
                LOGGER.debug("", e);
            }
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scanSize) {
            LOGGER.debug("Storing row {} of {} ({}%)", new Object[]{y, this.yy + this.hh, (double)y / (double)(this.yy + this.hh) * 100.0});
            if (y >= this.yy + this.hh) {
                this.imageComplete(0);
                return;
            }
            if (y < this.yy) {
                return;
            }
            try {
                JPEGTileDecoder.this.tiles.add(pixels, x, y, w, h);
            }
            catch (FormatException e) {
                LOGGER.debug("", e);
            }
            catch (IOException e) {
                LOGGER.debug("", e);
            }
        }

        public void setProperties(Hashtable props) {
        }

        public void setColorModel(ColorModel model) {
        }

        public void setHints(int hintFlags) {
        }
    }
}

