/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.gui.GenericDialog;
import java.awt.Container;
import loci.common.Region;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.WindowTools;

public class CropDialog
extends ImporterDialog {
    public CropDialog(ImportProcess process) {
        super(process);
    }

    protected boolean needPrompt() {
        return !this.process.isWindowless() && this.options.doCrop();
    }

    protected GenericDialog constructDialog() {
        int seriesCount = this.process.getSeriesCount();
        ImageProcessorReader r = this.process.getReader();
        GenericDialog gd = new GenericDialog("Bio-Formats Crop Options");
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            r.setSeries(s);
            Region region = this.process.getCropRegion(s);
            gd.addMessage(this.process.getSeriesLabel(s).replaceAll("_", " "));
            gd.addNumericField("X_Coordinate_" + (s + 1), (double)region.x, 0);
            gd.addNumericField("Y_Coordinate_" + (s + 1), (double)region.y, 0);
            gd.addNumericField("Width_" + (s + 1), (double)region.width, 0);
            gd.addNumericField("Height_" + (s + 1), (double)region.height, 0);
        }
        WindowTools.addScrollBars((Container)gd);
        return gd;
    }

    protected boolean harvestResults(GenericDialog gd) {
        int seriesCount = this.process.getSeriesCount();
        ImageProcessorReader r = this.process.getReader();
        for (int s = 0; s < seriesCount; ++s) {
            if (!this.options.isSeriesOn(s)) continue;
            r.setSeries(s);
            Region region = new Region();
            region.x = (int)gd.getNextNumber();
            region.y = (int)gd.getNextNumber();
            region.width = (int)gd.getNextNumber();
            region.height = (int)gd.getNextNumber();
            if (region.x < 0) {
                region.x = 0;
            }
            if (region.y < 0) {
                region.y = 0;
            }
            if (region.x >= r.getSizeX()) {
                region.x = r.getSizeX() - region.width - 1;
            }
            if (region.y >= r.getSizeY()) {
                region.y = r.getSizeY() - region.height - 1;
            }
            if (region.width < 1) {
                region.width = 1;
            }
            if (region.height < 1) {
                region.height = 1;
            }
            if (region.width + region.x > r.getSizeX()) {
                region.width = r.getSizeX() - region.x;
            }
            if (region.height + region.y > r.getSizeY()) {
                region.height = r.getSizeY() - region.y;
            }
            this.options.setCropRegion(s, region);
        }
        return true;
    }
}

