/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.filesystem.SoftLinkMaker;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.DispatcherStorageProcessor;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.utils.Unzipper;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.HierarchicalStructureDuplicatorFileToHDF5;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.IImageFileExtractor;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractionResult;
import ch.systemsx.cisd.openbis.dss.etl.PlateStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.RelativeImageReference;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageSeriesPoint;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageStorageConfiguraton;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import ch.systemsx.cisd.openbis.dss.etl.jython.v1.JythonPlateDataSetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ChannelDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

abstract class AbstractImageStorageProcessor
extends AbstractStorageProcessor
implements DispatcherStorageProcessor.IDispatchableStorageProcessor {
    public static final String ARCHIVE_DELIMITER = "/";
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PlateStorageProcessor.class);
    protected static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, PlateStorageProcessor.class);
    protected static final String FILE_EXTRACTOR_PROPERTY = "file-extractor";
    private static final String ORIGINAL_DATA_STORAGE_FORMAT_PROPERTY = "original-data-storage-format";
    private final DataSource dataSource;
    private final ImageStorageConfiguraton globalImageStorageConfiguraton;
    protected final IImageFileExtractor imageFileExtractorOrNull;

    protected abstract void storeInDatabase(IImagingQueryDAO var1, PlateStorageProcessor.ImageDatasetOwnerInformation var2, ImageFileExtractionResult var3, boolean var4);

    protected abstract boolean validateImages(PlateStorageProcessor.DatasetOwnerInformation var1, IMailClient var2, File var3, ImageFileExtractionResult var4);

    public AbstractImageStorageProcessor(Properties properties) {
        this(AbstractImageStorageProcessor.tryCreateImageExtractor(properties), properties);
    }

    protected AbstractImageStorageProcessor(IImageFileExtractor imageFileExtractorOrNull, Properties properties) {
        super(properties);
        this.imageFileExtractorOrNull = imageFileExtractorOrNull;
        this.globalImageStorageConfiguraton = AbstractImageStorageProcessor.getGlobalImageStorageConfiguraton(properties);
        this.dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
    }

    private static ImageStorageConfiguraton getGlobalImageStorageConfiguraton(Properties properties) {
        ImageStorageConfiguraton storageFormatParameters = new ImageStorageConfiguraton();
        storageFormatParameters.setOriginalDataStorageFormat(AbstractImageStorageProcessor.getOriginalDataStorageFormat(properties));
        return storageFormatParameters;
    }

    private static OriginalDataStorageFormat getOriginalDataStorageFormat(Properties properties) {
        String defaultValue = OriginalDataStorageFormat.UNCHANGED.name();
        String textValue = PropertyUtils.getProperty((Properties)properties, (String)ORIGINAL_DATA_STORAGE_FORMAT_PROPERTY, (String)defaultValue);
        return OriginalDataStorageFormat.valueOf(textValue.toUpperCase());
    }

    private static IImageFileExtractor tryCreateImageExtractor(Properties properties) {
        String fileExtractorClass = PropertyUtils.getProperty((Properties)properties, (String)FILE_EXTRACTOR_PROPERTY);
        if (fileExtractorClass != null) {
            return (IImageFileExtractor)ClassUtils.create(IImageFileExtractor.class, (String)fileExtractorClass, (Object[])new Object[]{properties});
        }
        return null;
    }

    private IImagingQueryDAO createQuery() {
        return (IImagingQueryDAO)QueryTool.getQuery((DataSource)this.dataSource, IImagingQueryDAO.class);
    }

    public final IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        return new AbstractImageStorageProcessorTransaction(parameters, this);
    }

    static File tryUnzipToFolder(File incomingDataSetDirectory) {
        if (!AbstractImageStorageProcessor.isZipFile((File)incomingDataSetDirectory)) {
            return null;
        }
        String outputDirName = FilenameUtils.getBaseName((String)incomingDataSetDirectory.getName());
        File output = new File(incomingDataSetDirectory.getParentFile(), outputDirName);
        Status status = Unzipper.unzip((File)incomingDataSetDirectory, (File)output, (boolean)true);
        if (status.isError()) {
            throw EnvironmentFailureException.fromTemplate((String)"Cannot unzip '%s': %s", (Object[])new Object[]{incomingDataSetDirectory.getName(), status});
        }
        return output;
    }

    private static String compressToHdf5(File rootDirectory, File imagesInStoreFolder, OriginalDataStorageFormat originalDataStorageFormat, File hdf5OriginalContainer) {
        File absolutePath = new File(rootDirectory, imagesInStoreFolder.getPath());
        if (hdf5OriginalContainer.isDirectory()) {
            throw ConfigurationFailureException.fromTemplate((String)"Cannot compress the dataset to HDF5 format during registration, probably the compression has been configured to be done in a separate step ('%s' is an existing directory). Check and switch on only one of them!", (Object[])new Object[]{hdf5OriginalContainer});
        }
        boolean isDataCompressed = originalDataStorageFormat == OriginalDataStorageFormat.HDF5_COMPRESSED;
        String pathInHdf5Container = ARCHIVE_DELIMITER + absolutePath.getName() + ARCHIVE_DELIMITER;
        AbstractImageStorageProcessor.saveInHdf5(absolutePath, pathInHdf5Container, hdf5OriginalContainer, isDataCompressed);
        String hdf5ArchivePathPrefix = String.valueOf(hdf5OriginalContainer.getName()) + ARCHIVE_DELIMITER;
        return String.valueOf(hdf5ArchivePathPrefix) + pathInHdf5Container;
    }

    private static File getHdf5OriginalContainer(File rootDirectory) {
        return new File(rootDirectory, "original.h5ar");
    }

    private static void saveInHdf5(File sourceFolder, String pathInHdf5Container, File hdf5DestinationFile, boolean compressFiles) {
        HDF5Container container = new HDF5Container(hdf5DestinationFile);
        container.runWriterClient(compressFiles, (HDF5Container.IHDF5WriterClient)new HierarchicalStructureDuplicatorFileToHDF5.DuplicatorWriterClient(sourceFolder, pathInHdf5Container));
    }

    private static void updateImagesRelativePath(String pathPrefixToAdd, List<AcquiredSingleImage> plateImages) {
        for (AcquiredSingleImage plateImage : plateImages) {
            RelativeImageReference imageReference = plateImage.getImageReference();
            imageReference.setRelativeImageFolder(pathPrefixToAdd);
        }
    }

    public boolean accepts(DataSetInformation dataSetInformation, File incomingDataSet) {
        String dataSetTypeCode = dataSetInformation.getDataSetType().getCode().toUpperCase();
        return dataSetInformation instanceof ImageDataSetInformation || dataSetTypeCode.matches("HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)") || dataSetTypeCode.matches("MICROSCOPY_IMAGE|.*IMG.*") || dataSetTypeCode.matches("HCS_ANALYSIS_FEATURES_LIST");
    }

    private ImageFileExtractionWithConfig extractImages(DataSetInformation dataSetInformation, File incomingDataSetDirectory) {
        if (this.imageFileExtractorOrNull == null) {
            return this.extractImagesFromDatasetInfoOrDie(dataSetInformation);
        }
        return this.deprecatedExtractImages(dataSetInformation, incomingDataSetDirectory, this.imageFileExtractorOrNull);
    }

    private ImageFileExtractionWithConfig deprecatedExtractImages(DataSetInformation dataSetInformation, File incomingDataSetDirectory, IImageFileExtractor extractor) {
        ImageFileExtractionResult result = extractor.extract(incomingDataSetDirectory, dataSetInformation);
        if (result.getImages().size() == 0) {
            throw new UserFailureException("No images found in the incoming diretcory: " + incomingDataSetDirectory);
        }
        PlateStorageProcessor.ImageDatasetOwnerInformation imageDatasetOwner = PlateStorageProcessor.ImageDatasetOwnerInformation.create(dataSetInformation.getDataSetCode(), dataSetInformation, null);
        return new ImageFileExtractionWithConfig(imageDatasetOwner, result, this.globalImageStorageConfiguraton);
    }

    private ImageFileExtractionWithConfig extractImagesFromDatasetInfoOrDie(DataSetInformation dataSetInformation) {
        if (!(dataSetInformation instanceof ImageDataSetInformation)) {
            throw ConfigurationFailureException.fromTemplate((String)"File extractor '%s' has not been configured or jython script in 'top-level-data-set-handler' is not '%s'.", (Object[])new Object[]{FILE_EXTRACTOR_PROPERTY, JythonPlateDataSetHandler.class.getCanonicalName()});
        }
        return this.extractImagesFromDatasetInfo((ImageDataSetInformation)dataSetInformation);
    }

    private ImageFileExtractionWithConfig extractImagesFromDatasetInfo(ImageDataSetInformation dataSetInformation) {
        ImageDataSetStructure imageDataSetStructure = dataSetInformation.getImageDataSetStructure();
        if (!imageDataSetStructure.isValid()) {
            throw new ConfigurationFailureException("Invalid image dataset info object, check if your jython script fills all the required fields. Or maybe the recognized files extensions is set incorrectly? Dataset: " + imageDataSetStructure);
        }
        Geometry tileGeometry = new Geometry(imageDataSetStructure.getTileRowsNumber(), imageDataSetStructure.getTileColumnsNumber());
        ThumbnailsInfo thumbnailsInfo = dataSetInformation.getThumbnailsInfos();
        List<AcquiredSingleImage> images = AbstractImageStorageProcessor.convertImages(imageDataSetStructure, thumbnailsInfo);
        ArrayList<File> invalidFiles = new ArrayList<File>();
        ImageStorageConfiguraton imageStorageConfiguraton = imageDataSetStructure.getImageStorageConfiguraton();
        if (imageStorageConfiguraton == null) {
            imageStorageConfiguraton = this.globalImageStorageConfiguraton;
        }
        this.setPerImageTransformationIfNeeded(images, imageStorageConfiguraton);
        ImageFileExtractionResult extractionResult = new ImageFileExtractionResult(images, dataSetInformation.getDatasetRelativeImagesFolderPath(), invalidFiles, imageDataSetStructure.getChannels(), tileGeometry, imageStorageConfiguraton.getStoreChannelsOnExperimentLevel(), imageStorageConfiguraton.tryGetImageLibrary());
        PlateStorageProcessor.ImageDatasetOwnerInformation imageDatasetOwner = PlateStorageProcessor.ImageDatasetOwnerInformation.create(dataSetInformation.tryGetContainerDatasetPermId(), dataSetInformation, thumbnailsInfo);
        return new ImageFileExtractionWithConfig(imageDatasetOwner, extractionResult, imageStorageConfiguraton);
    }

    private static List<AcquiredSingleImage> convertImages(ImageDataSetStructure imageDataSetStructure, ThumbnailsInfo thumbnailFilePathsOrNull) {
        List<ImageFileInfo> imageInfos = imageDataSetStructure.getImages();
        List<ChannelColorComponent> channelColorComponentsOrNull = imageDataSetStructure.getChannelColorComponents();
        List<Channel> channels = imageDataSetStructure.getChannels();
        ArrayList<AcquiredSingleImage> images = new ArrayList<AcquiredSingleImage>();
        for (ImageFileInfo imageInfo : imageInfos) {
            if (channelColorComponentsOrNull != null) {
                int i = 0;
                while (i < channelColorComponentsOrNull.size()) {
                    ColorComponent colorComponent = AbstractImageStorageProcessor.asColorComponent(channelColorComponentsOrNull.get(i));
                    Channel channel = channels.get(i);
                    AcquiredSingleImage image = AbstractImageFileExtractor.createImage(imageInfo, channel.getCode(), colorComponent, thumbnailFilePathsOrNull);
                    images.add(image);
                    ++i;
                }
                continue;
            }
            images.addAll(AbstractImageFileExtractor.createImagesWithNoColorComponent(imageInfo, thumbnailFilePathsOrNull));
        }
        return images;
    }

    private static ColorComponent asColorComponent(ChannelColorComponent channelColorComponent) {
        return ColorComponent.valueOf(channelColorComponent.name());
    }

    private void setPerImageTransformationIfNeeded(List<AcquiredSingleImage> images, ImageStorageConfiguraton imageStorageConfiguraton) {
        if (imageStorageConfiguraton != null && imageStorageConfiguraton.getImageTransformerFactory() != null) {
            IImageTransformerFactory imgTransformerFactory = imageStorageConfiguraton.getImageTransformerFactory();
            for (AcquiredSingleImage image : images) {
                image.setImageTransformerFactory(imgTransformerFactory);
            }
        }
    }

    private static void commitHdf5StorageFormatChanges(File storedDataDirectory) {
        File originalFolder = AbstractImageStorageProcessor.getOriginalFolder(storedDataDirectory);
        File hdf5OriginalContainer = AbstractImageStorageProcessor.getHdf5OriginalContainer(storedDataDirectory);
        if (hdf5OriginalContainer.exists()) {
            IFileOperations fileOps = FileOperations.getMonitoredInstanceForCurrentThread();
            if (!fileOps.removeRecursivelyQueueing(originalFolder)) {
                operationLog.error((Object)("Cannot delete original data '" + originalFolder.getAbsolutePath() + "'."));
            }
        } else {
            notificationLog.error((Object)String.format("HDF5 container with original data '%s' could not be found, this should not happen! Dataset should be registered again! Keeping the original directory '%s'.", hdf5OriginalContainer, originalFolder));
        }
    }

    private static File getOriginalFolder(File storedDataDirectory) {
        return new File(storedDataDirectory, "original");
    }

    private static File moveFileToDirectory(File source, File directory) throws EnvironmentFailureException {
        assert (source != null);
        IFileOperations fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        assert (directory != null && fileOperations.isDirectory(directory));
        String newName = source.getName();
        File destination = new File(directory, newName);
        if (!fileOperations.exists(destination)) {
            if (FileUtilities.isSymbolicLink((File)source)) {
                AbstractImageStorageProcessor.moveSymbolicLink(source, destination);
            } else {
                boolean successful = fileOperations.rename(source, destination);
                if (!successful) {
                    throw EnvironmentFailureException.fromTemplate((String)"Can not move file '%s' to directory '%s'.", (Object[])new Object[]{source.getAbsolutePath(), directory.getAbsolutePath()});
                }
            }
            return destination;
        }
        throw EnvironmentFailureException.fromTemplate((String)"Can not move file '%s' to directory '%s' because the destination directory already exists.", (Object[])new Object[]{source.getAbsolutePath(), directory.getAbsolutePath()});
    }

    private static void moveSymbolicLink(File source, File destination) {
        File referencedSource;
        try {
            referencedSource = source.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new EnvironmentFailureException("cannot get the canonical path of " + source);
        }
        boolean ok = SoftLinkMaker.createSymbolicLink((File)referencedSource, (File)destination);
        if (!ok) {
            throw EnvironmentFailureException.fromTemplate((String)"Can not create symbolic link to '%s' in '%s'.", (Object[])new Object[]{referencedSource.getPath(), destination.getPath()});
        }
        ok = source.delete();
        if (!ok) {
            throw EnvironmentFailureException.fromTemplate((String)"Can not delete symbolic link '%s'.", (Object[])new Object[]{source.getPath()});
        }
    }

    protected static List<String> extractChannelCodes(List<ChannelDescription> descriptions) {
        ArrayList<String> channelCodes = new ArrayList<String>();
        for (ChannelDescription cd : descriptions) {
            channelCodes.add(cd.getCode());
        }
        return channelCodes;
    }

    protected static List<String> extractChannelLabels(List<ChannelDescription> descriptions) {
        ArrayList<String> channelLabels = new ArrayList<String>();
        for (ChannelDescription cd : descriptions) {
            channelLabels.add(cd.getLabel());
        }
        return channelLabels;
    }

    protected static String getChannelCodeOrLabel(List<String> channelCodes, int channelId) {
        if (channelId > channelCodes.size()) {
            throw UserFailureException.fromTemplate((String)"Too large channel number %d, configured channels: %s.", (Object[])new Object[]{channelId, CollectionUtils.abbreviate(channelCodes, (int)-1)});
        }
        return channelCodes.get(channelId - 1);
    }

    protected static boolean hasImageSeries(List<AcquiredSingleImage> images) {
        HashSet<ImageSeriesPoint> points = new HashSet<ImageSeriesPoint>();
        for (AcquiredSingleImage image : images) {
            if (image.tryGetTimePoint() == null && image.tryGetDepth() == null && image.tryGetSeriesNumber() == null) continue;
            points.add(new ImageSeriesPoint(image.tryGetTimePoint(), image.tryGetDepth(), image.tryGetSeriesNumber()));
        }
        return points.size() > 1;
    }

    protected static class AbstractImageStorageProcessorTransaction
    extends AbstractStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final IStorageProcessorTransactional.UnstoreDataAction unstoreAction;
        private final transient AbstractImageStorageProcessor processor;
        private transient IImagingQueryDAO dbTransaction;
        private transient boolean shouldDeleteOriginalDataOnCommit;
        private transient List<File> generatedFiles;

        public AbstractImageStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, AbstractImageStorageProcessor processor) {
            super(parameters);
            this.processor = processor;
            this.unstoreAction = processor.getDefaultUnstoreDataAction(null);
            this.generatedFiles = new ArrayList<File>();
        }

        public final File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            assert (this.rootDirectory != null) : "Root directory can not be null.";
            assert (this.incomingDataSetDirectory != null) : "Incoming data set directory can not be null.";
            assert (typeExtractor != null) : "Unspecified IProcedureAndDataTypeExtractor implementation.";
            File unzipedFolder = AbstractImageStorageProcessor.tryUnzipToFolder(this.incomingDataSetDirectory);
            if (unzipedFolder != null) {
                this.incomingDataSetDirectory = unzipedFolder;
                return this.getStoredDataDirectory();
            }
            if (!this.isImageDataset()) {
                this.plainMoveToStore();
                return this.rootDirectory;
            }
            ImageFileExtractionWithConfig extractionResultWithConfig = this.processor.extractImages(this.dataSetInformation, this.incomingDataSetDirectory);
            ImageFileExtractionResult extractionResult = extractionResultWithConfig.getExtractionResult();
            this.validateImages(mailClient, extractionResultWithConfig, extractionResult);
            List<AcquiredSingleImage> plateImages = extractionResult.getImages();
            ImageStorageConfiguraton imageStorageConfiguraton = extractionResultWithConfig.getImageStorageConfiguraton();
            this.plainMoveToStore();
            File datasetRelativeImagesFolderPath = extractionResultWithConfig.getExtractionResult().getDatasetRelativeImagesFolderPath();
            if (!this.getRegisterAsOverviewImageDataSet(this.dataSetInformation)) {
                this.processImages(plateImages, datasetRelativeImagesFolderPath, imageStorageConfiguraton);
            }
            this.shouldDeleteOriginalDataOnCommit = imageStorageConfiguraton.getOriginalDataStorageFormat().isHdf5() && !this.getRegisterAsOverviewImageDataSet(this.dataSetInformation);
            this.dbTransaction = this.processor.createQuery();
            this.processor.storeInDatabase(this.dbTransaction, extractionResultWithConfig.getImageDatasetOwner(), extractionResult, this.getRegisterAsOverviewImageDataSet(this.dataSetInformation));
            return this.rootDirectory;
        }

        private boolean getRegisterAsOverviewImageDataSet(DataSetInformation dataSetInfo) {
            if (!(dataSetInfo instanceof ImageDataSetInformation)) {
                return false;
            }
            return ((ImageDataSetInformation)dataSetInfo).getRegisterAsOverviewImageDataSet();
        }

        private void processImages(List<AcquiredSingleImage> images, File datasetRelativeImagesFolderPath, ImageStorageConfiguraton imageStorageConfiguraton) {
            String relativeImagesDirectory;
            OriginalDataStorageFormat originalDataStorageFormat = imageStorageConfiguraton.getOriginalDataStorageFormat();
            if (originalDataStorageFormat.isHdf5()) {
                File hdf5OriginalContainer = AbstractImageStorageProcessor.getHdf5OriginalContainer(this.rootDirectory);
                relativeImagesDirectory = AbstractImageStorageProcessor.compressToHdf5(this.rootDirectory, datasetRelativeImagesFolderPath, originalDataStorageFormat, hdf5OriginalContainer);
                this.generatedFiles.add(hdf5OriginalContainer);
            } else {
                relativeImagesDirectory = String.valueOf(datasetRelativeImagesFolderPath.getPath()) + AbstractImageStorageProcessor.ARCHIVE_DELIMITER;
            }
            AbstractImageStorageProcessor.updateImagesRelativePath(relativeImagesDirectory, images);
        }

        private void validateImages(IMailClient mailClient, ImageFileExtractionWithConfig extractionResultWithConfig, ImageFileExtractionResult extractionResult) {
            boolean isComplete = this.processor.validateImages(extractionResultWithConfig.getImageDatasetOwner(), mailClient, this.incomingDataSetDirectory, extractionResult);
            this.dataSetInformation.setComplete(isComplete);
        }

        private boolean isImageDataset() {
            return this.processor.imageFileExtractorOrNull != null || this.dataSetInformation instanceof ImageDataSetInformation;
        }

        private File plainMoveToStore() {
            File destDir = this.rootDirectory;
            if (this.processor.imageFileExtractorOrNull != null) {
                destDir = AbstractImageStorageProcessor.getOriginalFolder(destDir);
                destDir.mkdirs();
            }
            File newLocationDir = AbstractImageStorageProcessor.moveFileToDirectory(this.incomingDataSetDirectory, destDir);
            this.storedDataDirectory = this.rootDirectory;
            return newLocationDir;
        }

        protected void executeCommit() {
            if (this.shouldDeleteOriginalDataOnCommit) {
                AbstractImageStorageProcessor.commitHdf5StorageFormatChanges(this.storedDataDirectory);
            }
            if (this.dbTransaction != null) {
                this.dbTransaction.close(true);
            }
        }

        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable exception) {
            this.moveFilesBackFromStore();
            if (this.dbTransaction != null) {
                this.rollbackDatabaseChanges();
            }
            return this.unstoreAction;
        }

        private void rollbackDatabaseChanges() {
            try {
                this.dbTransaction.rollback();
            }
            finally {
                this.dbTransaction.close();
            }
        }

        public final File tryGetProprietaryData() {
            return AbstractImageStorageProcessorTransaction.tryGetSingleChild(this.storedDataDirectory);
        }

        private static final File tryGetSingleChild(File parentDirectory) {
            assert (parentDirectory != null) : "Unspecified parentDirectory";
            File[] content = parentDirectory.listFiles();
            if (content == null || content.length == 0) {
                return null;
            }
            if (content.length > 1) {
                operationLog.error((Object)("There should be exactly one folder inside '" + parentDirectory + "', but " + parentDirectory.length() + " has been found."));
                return null;
            }
            File childFile = content[0];
            if (!childFile.exists()) {
                operationLog.error((Object)("The child file '" + childFile.getAbsolutePath() + "' does not exist."));
                return null;
            }
            return childFile;
        }

        private final void moveFilesBackFromStore() {
            File originalDataFile;
            if (this.storedDataDirectory == null) {
                this.storedDataDirectory = this.rootDirectory;
            }
            AbstractImageStorageProcessor.checkParameters((File)this.incomingDataSetDirectory, (File)this.storedDataDirectory);
            IFileOperations fileOps = FileOperations.getMonitoredInstanceForCurrentThread();
            if (this.generatedFiles != null) {
                for (File generatedFile : this.generatedFiles) {
                    AbstractImageStorageProcessorTransaction.deleteRecursively(fileOps, generatedFile);
                }
            }
            if ((originalDataFile = AbstractImageStorageProcessorTransaction.tryGetSingleChild(this.storedDataDirectory)) == null) {
                return;
            }
            File incomingDirectory = this.incomingDataSetDirectory.getParentFile();
            try {
                AbstractImageStorageProcessor.moveFileToDirectory(originalDataFile, incomingDirectory);
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)String.format("Storage operation rollback: directory '%s' has moved to incoming directory '%s'.", originalDataFile, incomingDirectory.getAbsolutePath()));
                }
            }
            catch (EnvironmentFailureException ex) {
                notificationLog.error((Object)String.format("Could not move '%s' to the directory '%s'.", originalDataFile, incomingDirectory.getAbsolutePath()), (Throwable)ex);
                return;
            }
            if (fileOps.exists(this.incomingDataSetDirectory)) {
                AbstractImageStorageProcessorTransaction.deleteRecursively(fileOps, this.storedDataDirectory);
            } else {
                notificationLog.error((Object)String.format("Incoming data set directory '%s' does not exist, keeping store directory '%s'.", this.incomingDataSetDirectory, this.storedDataDirectory));
            }
        }

        private static void deleteRecursively(IFileOperations fileOps, File file) {
            if (!fileOps.removeRecursivelyQueueing(file)) {
                operationLog.error((Object)("Cannot delete '" + file.getAbsolutePath() + "'."));
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            this.storedDataDirectory = this.rootDirectory;
        }
    }

    private final class ImageFileExtractionWithConfig {
        private final PlateStorageProcessor.ImageDatasetOwnerInformation imageDatasetOwner;
        private final ImageFileExtractionResult extractionResult;
        private final ImageStorageConfiguraton imageStorageConfiguraton;

        public ImageFileExtractionWithConfig(PlateStorageProcessor.ImageDatasetOwnerInformation imageDatasetOwner, ImageFileExtractionResult extractionResult, ImageStorageConfiguraton imageStorageConfiguraton) {
            assert (imageDatasetOwner != null) : "imageDatasetOwner is null";
            assert (extractionResult != null) : "extractionResult is null";
            assert (imageStorageConfiguraton != null) : "imageStorageConfiguraton is null";
            this.imageDatasetOwner = imageDatasetOwner;
            this.extractionResult = extractionResult;
            this.imageStorageConfiguraton = imageStorageConfiguraton;
        }

        public PlateStorageProcessor.ImageDatasetOwnerInformation getImageDatasetOwner() {
            return this.imageDatasetOwner;
        }

        public ImageFileExtractionResult getExtractionResult() {
            return this.extractionResult;
        }

        public ImageStorageConfiguraton getImageStorageConfiguraton() {
            return this.imageStorageConfiguraton;
        }
    }
}

