/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.AbsoluteImageReference;
import ch.systemsx.cisd.openbis.dss.etl.IImagingDatasetLoader;
import ch.systemsx.cisd.openbis.dss.etl.IImagingLoaderStrategy;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.ImageChannelStackReference;
import ch.systemsx.cisd.openbis.dss.generic.server.images.dto.RequestedImageSize;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.util.List;

public class ImagingLoaderStrategyFactory {
    public static IImagingLoaderStrategy createThumbnailLoaderStrategy(IImagingDatasetLoader imageAccessor) {
        return new AbstractLoaderStrategy(imageAccessor){

            @Override
            public AbsoluteImageReference tryGetImage(String channelCode, ImageChannelStackReference channelStackReference, RequestedImageSize imageSize, String transformationCodeOrNull) {
                return this.imageAccessor.tryGetThumbnail(channelCode, channelStackReference, imageSize, transformationCodeOrNull);
            }

            @Override
            public AbsoluteImageReference tryGetRepresentativeImage(String channelCode, Location wellLocationOrNull, RequestedImageSize imageSize, String transformationCodeOrNull) {
                return this.imageAccessor.tryGetRepresentativeThumbnail(channelCode, wellLocationOrNull, imageSize, transformationCodeOrNull);
            }
        };
    }

    public static IImagingLoaderStrategy createImageLoaderStrategy(IImagingDatasetLoader imageAccessor) {
        return new AbstractLoaderStrategy(imageAccessor){

            @Override
            public AbsoluteImageReference tryGetImage(String channelCode, ImageChannelStackReference channelStackReference, RequestedImageSize imageSize, String transformationCodeOrNull) {
                return this.imageAccessor.tryGetImage(channelCode, channelStackReference, imageSize, transformationCodeOrNull);
            }

            @Override
            public AbsoluteImageReference tryGetRepresentativeImage(String channelCode, Location wellLocationOrNull, RequestedImageSize imageSize, String transformationCodeOrNull) {
                return this.imageAccessor.tryGetRepresentativeImage(channelCode, wellLocationOrNull, imageSize, transformationCodeOrNull);
            }
        };
    }

    private static abstract class AbstractLoaderStrategy
    implements IImagingLoaderStrategy {
        protected final IImagingDatasetLoader imageAccessor;

        private AbstractLoaderStrategy(IImagingDatasetLoader imageAccessor) {
            this.imageAccessor = imageAccessor;
        }

        @Override
        public ImageDatasetParameters getImageParameters() {
            return this.imageAccessor.getImageParameters();
        }

        @Override
        public List<ImageChannelStack> listImageChannelStacks(WellLocation wellLocationOrNull) {
            return this.imageAccessor.listImageChannelStacks(wellLocationOrNull);
        }
    }
}

