/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j;

import ch.systemsx.cisd.args4j.IllegalAnnotationError;
import ch.systemsx.cisd.args4j.Messages;
import ch.systemsx.cisd.args4j.spi.Setter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiValueFieldSetter
implements Setter<Object> {
    private final Object bean;
    private final Field f;

    public MultiValueFieldSetter(Object bean, Field f) {
        this.bean = bean;
        this.f = f;
        if (!List.class.isAssignableFrom(f.getType())) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(f.getType()));
        }
    }

    @Override
    public Class<Object> getType() {
        ParameterizedType pt;
        Type t = this.f.getGenericType();
        if (t instanceof ParameterizedType && (t = (pt = (ParameterizedType)t).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)t;
        }
        return Object.class;
    }

    @Override
    public void addValue(Object value) {
        try {
            this.doAddValue(this.bean, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.f.setAccessible(true);
            try {
                this.doAddValue(this.bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private void doAddValue(Object beanToAddValueTo, Object value) throws IllegalAccessException {
        ArrayList o = this.f.get(beanToAddValueTo);
        if (o == null) {
            o = new ArrayList();
            this.f.set(beanToAddValueTo, o);
        }
        if (!(o instanceof List)) {
            throw new IllegalAnnotationError("type of " + this.f + " is not a List");
        }
        ((List)o).add(value);
    }
}

