/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.ldap;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.ldap.LDAPDirectoryConfiguration;
import ch.systemsx.cisd.authentication.ldap.LDAPPrincipalQuery;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.util.List;

public class LDAPAuthenticationService
implements IAuthenticationService {
    private static final String DUMMY_TOKEN_STR = "DUMMY-TOKEN";
    private final LDAPPrincipalQuery query;

    public LDAPAuthenticationService(LDAPDirectoryConfiguration config) {
        this.query = new LDAPPrincipalQuery(config);
    }

    @Override
    public String authenticateApplication() {
        return DUMMY_TOKEN_STR;
    }

    @Override
    public boolean authenticateUser(String applicationToken, String user, String password) {
        return this.authenticateUser(user, password);
    }

    @Override
    public boolean authenticateUser(String user, String password) {
        return this.query.authenticateUser(user, password);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String applicationToken, String user, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(user, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String user, String passwordOrNull) {
        return this.query.tryGetAndAuthenticatePrincipal(user, passwordOrNull);
    }

    @Override
    public Principal getPrincipal(String applicationToken, String user) throws IllegalArgumentException {
        return this.getPrincipal(user);
    }

    @Override
    public Principal getPrincipal(String user) throws IllegalArgumentException {
        Principal principalOrNull = this.query.tryGetPrincipal(user);
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + user + "'.");
        }
        return principalOrNull;
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String applicationToken, String emailQuery) {
        return this.listPrincipalsByEmail(emailQuery);
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) {
        return this.query.listPrincipalsByEmail(emailQuery);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String applicationToken, String email, String passwordOrNull) {
        return this.tryGetAndAuthenticateUserByEmail(email, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        return this.query.tryGetAndAuthenticatePrincipalByEmail(email, passwordOrNull);
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String applicationToken, String lastNameQuery) {
        return this.listPrincipalsByLastName(lastNameQuery);
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) {
        return this.query.listPrincipalsByLastName(lastNameQuery);
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String applicationToken, String userIdQuery) {
        return this.listPrincipalsByUserId(userIdQuery);
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) {
        return this.query.listPrincipalsByUserId(userIdQuery);
    }

    @Override
    public boolean supportsListingByEmail() {
        return true;
    }

    @Override
    public boolean supportsListingByLastName() {
        return true;
    }

    @Override
    public boolean supportsListingByUserId() {
        return true;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        this.query.check();
    }

    @Override
    public boolean isRemote() {
        return this.query.isRemote();
    }
}

