/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.DOMUtils;
import ch.systemsx.cisd.cifex.client.application.utils.FileUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.BasicUserInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.OwnerFileInfoDTO;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

public class OwnedFileGridModel
extends AbstractFileGridModel {
    private static final long serialVersionUID = 1L;

    public OwnedFileGridModel(OwnerFileInfoDTO file) {
        this.set("id", file.getID());
        this.set("name", file.getName());
        this.set("comment", file.getComment());
        this.set("owner", file.getOwner());
        this.set("sharedWith", BasicUserInfoDTO.concatUserCodes(file.getSharingUsers()));
        this.set("contentType", file.getContentType());
        this.set("size", FileUtils.tryToGetFileSize(file));
        this.set("completeSize", new Double(file.getCompleteSize()));
        this.set("isComplete", file.isComplete());
        this.set("crc32Checksum", file.getCrc32Str());
        this.set("registrationDate", file.getRegistrationDate());
        this.set("expirationDate", file.getExpirationDate());
        this.set("action", String.valueOf(DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_EDIT_LABEL), "edit")) + " | " + DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_EDITSHARING_LABEL), "shared") + " | " + DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_DELETE_LABEL), "delete"));
    }

    @Override
    public long getID() {
        return (Long)this.get("id");
    }

    public static final List<ColumnConfig> getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(OwnedFileGridModel.createIdColumnConfig());
        configs.add(OwnedFileGridModel.createNameColumnConfig());
        configs.add(OwnedFileGridModel.createCommentColumnConfig());
        configs.add(OwnedFileGridModel.createOwnerColumnConfig());
        configs.add(OwnedFileGridModel.createSharedWithColumnConfig());
        configs.add(OwnedFileGridModel.createContentTypeColumnConfig());
        configs.add(OwnedFileGridModel.createSizeColumnConfig());
        configs.add(OwnedFileGridModel.createCompleteSizeColumnConfig());
        configs.add(OwnedFileGridModel.createIsCompleteColumnConfig());
        configs.add(OwnedFileGridModel.createCRC32ChecksumColumnConfig());
        configs.add(OwnedFileGridModel.createRegistrationDateColumnConfig());
        configs.add(OwnedFileGridModel.createExpirationDateColumnConfig());
        configs.add(OwnedFileGridModel.createActionColumnConfig());
        return configs;
    }

    public static final List<AbstractFileGridModel> convert(List<OwnerFileInfoDTO> filters) {
        ArrayList<AbstractFileGridModel> result = new ArrayList<AbstractFileGridModel>();
        for (OwnerFileInfoDTO filter : filters) {
            result.add(new OwnedFileGridModel(filter));
        }
        return result;
    }
}

