/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.PageControllerHelper;
import ch.systemsx.cisd.cifex.client.application.utils.InfoDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.CurrentUserInfoDTO;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Widget;

public class LoginPanelAutofill
extends VerticalPanel {
    private final ViewContext context;
    private final FormPanel formPanel;
    private static final String LOGIN_FORM_ID = "cifex_login_form";
    private static final String USERNAME_ID = "cifex-username";
    private static final String PASSWORD_ID = "cifex-password";
    private static final String SUBMIT_ID = "cifex-submit";
    private static LoginPanelAutofill singleton = null;

    public static LoginPanelAutofill get(ViewContext context) {
        if (singleton == null) {
            singleton = new LoginPanelAutofill(context);
        }
        return singleton;
    }

    private LoginPanelAutofill(ViewContext context) {
        this.context = context;
        this.setHorizontalAlign(Style.HorizontalAlignment.CENTER);
        Element formElement = Document.get().getElementById(LOGIN_FORM_ID);
        if (formElement == null) {
            MessageBox.alert((String)"Internal Error", (String)"Login form not found.", null);
            this.formPanel = null;
            return;
        }
        this.formPanel = FormPanel.wrap((Element)formElement, (boolean)true);
        this.formPanel.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                LoginPanelAutofill.this.getButtonElement().setDisabled(true);
            }
        });
        this.formPanel.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                if (!LoginPanelAutofill.this.isUserInputValid()) {
                    String title = MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_WARNING_TITLE);
                    MessageBox.alert((String)title, (String)MessageDictionary.msg(MessageDictionary.LOGIN_FAILED_MSG), null);
                    LoginPanelAutofill.this.getButtonElement().setDisabled(false);
                } else {
                    LoginPanelAutofill.this.doLogin();
                }
            }
        });
        this.add((Widget)this.formPanel);
        Text label = new Text(InfoDictionary.info(InfoDictionary.START_PAGE_WELCOME_NOTE));
        label.setStyleName("cifex-welcome-warning");
        this.add((Component)label);
    }

    private final boolean isUserInputValid() {
        String username = this.getUsernameElement().getValue();
        String password = this.getPasswordElement().getValue();
        return !StringUtils.isBlank(username) && !StringUtils.isBlank(password);
    }

    private void giveFocusToFirstField() {
        this.getUsernameElement().focus();
    }

    protected final void onLoad() {
        super.onLoad();
        this.getButtonElement().setDisabled(false);
        this.giveFocusToFirstField();
    }

    private final void doLogin() {
        InputElement usernameElement = this.getUsernameElement();
        InputElement passwordElement = this.getPasswordElement();
        String user = usernameElement.getValue();
        String password = passwordElement.getValue();
        this.context.getCifexService().tryLogin(user, password, new LoginAsyncCallBack());
    }

    public InputElement getPasswordElement() {
        return InputElement.as((Element)Document.get().getElementById(PASSWORD_ID));
    }

    public InputElement getUsernameElement() {
        return InputElement.as((Element)Document.get().getElementById(USERNAME_ID));
    }

    public final InputElement getButtonElement() {
        return InputElement.as((Element)Document.get().getElementById(SUBMIT_ID));
    }

    protected void loginSuccessful(CurrentUserInfoDTO currentUser) {
        this.getPasswordElement().setValue(this.getPasswordElement().getDefaultValue());
        PageControllerHelper.activatePageBasedOnCurrentContext(this.context, currentUser);
    }

    private final class LoginAsyncCallBack
    extends AbstractAsyncCallback<CurrentUserInfoDTO> {
        LoginAsyncCallBack() {
            super(LoginPanelAutofill.this.context);
        }

        @Override
        public final void onFailure(Throwable caught) {
            super.onFailure(caught);
            LoginPanelAutofill.this.getButtonElement().setDisabled(false);
        }

        public final void onSuccess(CurrentUserInfoDTO result) {
            if (result != null) {
                LoginPanelAutofill.this.loginSuccessful(result);
            } else {
                String title = MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_WARNING_TITLE);
                MessageBox.alert((String)title, (String)MessageDictionary.msg(MessageDictionary.LOGIN_FAILED_MSG), null);
                LoginPanelAutofill.this.getButtonElement().setDisabled(false);
            }
        }
    }
}

