/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.utils;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public final class DOMUtils {
    public static final String BR = DOM.toString((Element)DOM.createElement((String)"br"));

    private DOMUtils() {
    }

    public static final String renderItalic(String text) {
        assert (text != null) : "Given text can not be null.";
        Element element = DOM.createElement((String)"i");
        DOM.setInnerText((Element)element, (String)text);
        return DOM.toString((Element)element);
    }

    public static final String getElementValue(String tagName, String text) {
        assert (tagName != null) : "Tag name can not be null.";
        assert (text != null) : "Given text can not be null.";
        String startTag = "<" + tagName + ">";
        String endTag = "</" + tagName + ">";
        int endIndex = text.indexOf(endTag);
        if (text.indexOf(startTag) < 0 || endIndex < 0) {
            return text;
        }
        return text.substring(startTag.length(), endIndex);
    }

    public static final String createEmailAnchor(String email, String innerText) {
        assert (email != null) : "Undefined email.";
        Element anchor = DOMUtils.createBasicAnchorElement();
        DOM.setElementAttribute((Element)anchor, (String)"href", (String)("mailto:" + email));
        DOM.setElementAttribute((Element)anchor, (String)"title", (String)email);
        DOM.setInnerText((Element)anchor, (String)(innerText == null ? email : innerText));
        return DOM.toString((Element)anchor);
    }

    public static final String createAnchorWithTooltip(String tooltip, String innerText) {
        assert (tooltip != null) : "Undefined tooltip.";
        Element anchor = DOMUtils.createBasicAnchorElement();
        DOM.setElementAttribute((Element)anchor, (String)"title", (String)tooltip);
        DOM.setInnerText((Element)anchor, (String)(innerText == null ? tooltip : innerText));
        return DOM.toString((Element)anchor);
    }

    public static final Element createBasicAnchorElement() {
        Element anchor = DOM.createAnchor();
        DOM.setElementAttribute((Element)anchor, (String)"class", (String)"cifex-a");
        return anchor;
    }

    public static final String createAnchor(String value) {
        return DOMUtils.createAnchor(null, value, null, null, null, false);
    }

    public static final String createAnchor(String value, String id) {
        assert (value != null) : "Undefined value.";
        return DOMUtils.createAnchor(null, value, null, null, id, false);
    }

    public static final String createAnchor(String title, String value, String id, boolean html) {
        assert (value != null) : "Undefined value.";
        return DOMUtils.createAnchor(title, value, null, null, id, html);
    }

    public static final String createAnchor(String title, String value, String href, String target, String id, boolean html) {
        assert (value != null) : "Undefined value.";
        Element anchor = DOMUtils.createBasicAnchorElement();
        DOM.setElementAttribute((Element)anchor, (String)"href", (String)(href == null ? "javascript:return void;" : href));
        if (title != null) {
            DOM.setElementAttribute((Element)anchor, (String)"title", (String)title);
        } else if (href == null) {
            DOM.setElementAttribute((Element)anchor, (String)"title", (String)value);
        } else {
            DOM.setElementAttribute((Element)anchor, (String)"title", (String)href);
        }
        if (target != null) {
            DOM.setElementAttribute((Element)anchor, (String)"target", (String)target);
        }
        if (id != null) {
            DOM.setElementAttribute((Element)anchor, (String)"id", (String)id);
        }
        if (html) {
            DOM.setInnerHTML((Element)anchor, (String)value);
        } else {
            DOM.setInnerText((Element)anchor, (String)value);
        }
        return DOM.toString((Element)anchor);
    }
}

