/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.io;

import ch.systemsx.cisd.cifex.rpc.io.CRC32Utils;
import ch.systemsx.cisd.cifex.rpc.io.CloneableCRC32;
import ch.systemsx.cisd.cifex.rpc.io.ISimpleChecksummingProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.IntConversionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class ResumingAndChecksummingInputStream
extends InputStream {
    private final RandomAccessFile raFile;
    private final ISimpleChecksummingProgressListener listenerOrNull;
    private CloneableCRC32 crc32OrNull;
    private final long progressChunkSize;
    private final long length;
    private final ChecksumHandling checksumHandling;
    private StreamState state = StreamState.TRANSFER_CONTENT;
    private long bytesRead;
    private long bytesReadSinceListenerCalled;

    public ResumingAndChecksummingInputStream(File file) throws IOException {
        this(file, 0L, null, ChecksumHandling.COMPUTE);
    }

    public ResumingAndChecksummingInputStream(File file, ChecksumHandling checksumHandling) throws IOException {
        this(file, 0L, null, checksumHandling);
    }

    public ResumingAndChecksummingInputStream(File file, long startPos, ChecksumHandling checksumHandling) throws IOException {
        this(file, 0L, null, startPos, checksumHandling);
    }

    public ResumingAndChecksummingInputStream(File file, long progressChunkSize, ISimpleChecksummingProgressListener listenerOrNull, ChecksumHandling checksumHandling) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
        this.length = this.raFile.length();
        this.listenerOrNull = listenerOrNull;
        this.progressChunkSize = progressChunkSize;
        this.checksumHandling = checksumHandling;
        this.setStartPos(0L);
    }

    public ResumingAndChecksummingInputStream(File file, long progressChunkSize, ISimpleChecksummingProgressListener listenerOrNull, long startPos, ChecksumHandling checksumHandling) throws IOException, IllegalArgumentException {
        this.raFile = new RandomAccessFile(file, "r");
        this.length = this.raFile.length();
        this.listenerOrNull = listenerOrNull;
        this.progressChunkSize = progressChunkSize;
        this.checksumHandling = checksumHandling;
        this.setStartPos(startPos);
    }

    public ResumingAndChecksummingInputStream(File file, long progressChunkSize, ISimpleChecksummingProgressListener listenerOrNull, long startPos, int startCRC32, ChecksumHandling checksumHandling) throws IOException, IllegalArgumentException {
        this.raFile = new RandomAccessFile(file, "r");
        this.length = this.raFile.length();
        this.listenerOrNull = listenerOrNull;
        this.progressChunkSize = progressChunkSize;
        this.checksumHandling = checksumHandling;
        this.setStartPos(startPos, startCRC32);
    }

    @Override
    public void close() throws IOException {
        this.finishProgressReport();
        this.raFile.close();
    }

    @Override
    public int read() throws IOException {
        block8: {
            block7: {
                try {
                    if (this.state == StreamState.TRANSFER_CONTENT) break block7;
                    return -1;
                }
                catch (IOException ex) {
                    this.reportException(ex);
                    throw ex;
                }
            }
            this.checkEndOfContent();
            if (this.state == StreamState.TRANSFER_CONTENT) break block8;
            this.finishProgressReport();
            return -1;
        }
        int b = this.raFile.read();
        if (b >= 0) {
            if (this.crc32OrNull != null) {
                this.crc32OrNull.update(b);
            }
            this.updateProgress(1L);
        } else {
            this.finishProgressReport();
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        block12: {
            block11: {
                block10: {
                    block9: {
                        try {
                            if (this.state != StreamState.EOD) break block9;
                            return -1;
                        }
                        catch (IOException ex) {
                            this.reportException(ex);
                            throw ex;
                        }
                    }
                    if (len != 0) break block10;
                    return 0;
                }
                this.checkEndOfContent();
                if (this.state != StreamState.EOD) break block11;
                this.finishProgressReport();
                return -1;
            }
            if (this.state != StreamState.TRANSFER_CHECKSUM) break block12;
            IntConversionUtils.intToBytes(this.getCrc32Value(), b, off);
            this.state = StreamState.EOD;
            this.bytesReadSinceListenerCalled += 4L;
            return 4;
        }
        int actualLen = this.raFile.read(b, off, len);
        if (actualLen > 0) {
            if (this.crc32OrNull != null) {
                this.crc32OrNull.update(b, off, actualLen);
            }
            this.updateProgress(actualLen);
        } else {
            this.finishProgressReport();
        }
        return actualLen;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int getCrc32Value() {
        return this.crc32OrNull != null ? this.crc32OrNull.getIntValue() : 0;
    }

    public long getLength() {
        return this.length;
    }

    public void setStartPos(long startPos) throws IOException {
        if (startPos > this.length) {
            throw new IllegalArgumentException(String.format("Start position %s larger than file size %s.", startPos, this.length));
        }
        if (this.checksumHandling != ChecksumHandling.DONT_COMPUTE) {
            this.raFile.seek(0L);
            this.crc32OrNull = CRC32Utils.computeCRC32(this.raFile, startPos);
        } else {
            this.raFile.seek(startPos);
        }
        this.bytesRead = startPos;
        this.bytesReadSinceListenerCalled = 0L;
    }

    public void setStartPos(long startPos, int initialCrc32Value) throws IOException {
        if (startPos > this.length) {
            throw new IllegalArgumentException(String.format("Start position %s larger than file size %s.", startPos, this.length));
        }
        this.raFile.seek(startPos);
        if (this.checksumHandling != ChecksumHandling.DONT_COMPUTE) {
            this.crc32OrNull = new CloneableCRC32(initialCrc32Value);
        }
        this.bytesRead = startPos;
        this.bytesReadSinceListenerCalled = 0L;
    }

    private void reportException(IOException e) {
        if (this.listenerOrNull != null) {
            this.listenerOrNull.exceptionThrown(e);
        }
    }

    private void finishProgressReport() {
        if (this.bytesReadSinceListenerCalled > 0L) {
            if (this.listenerOrNull != null) {
                this.listenerOrNull.update(this.bytesRead, this.getCrc32Value());
            }
            this.bytesReadSinceListenerCalled = 0L;
        }
    }

    private long updateProgress(long chunkSize) {
        long actualChunkSize = Math.min(chunkSize, this.length - this.bytesRead);
        this.bytesRead += actualChunkSize;
        this.bytesReadSinceListenerCalled += actualChunkSize;
        if (this.bytesReadSinceListenerCalled >= this.progressChunkSize) {
            if (this.listenerOrNull != null) {
                this.listenerOrNull.update(this.bytesRead, this.getCrc32Value());
            }
            this.bytesReadSinceListenerCalled = 0L;
        }
        return actualChunkSize;
    }

    private void checkEndOfContent() {
        if (this.state == StreamState.TRANSFER_CONTENT && this.bytesRead == this.length) {
            this.state = this.checksumHandling == ChecksumHandling.COMPUTE_AND_APPEND ? StreamState.TRANSFER_CHECKSUM : StreamState.EOD;
        }
    }

    public static enum ChecksumHandling {
        COMPUTE,
        COMPUTE_AND_APPEND,
        DONT_COMPUTE;

    }

    private static enum StreamState {
        TRANSFER_CONTENT,
        TRANSFER_CHECKSUM,
        EOD;

    }
}

