/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Logger;

class MonitoringPoolingDataSource
extends PoolingDataSource {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, MonitoringPoolingDataSource.class);
    private static final Logger notifyLog = LogFactory.getLogger(LogCategory.NOTIFY, MonitoringPoolingDataSource.class);
    private final long activeConnectionsLogInterval;
    private final int activeConnectionsLogThreshold;
    private final boolean logStackTrace;
    private long lastLogged;
    private int maxActiveSinceLastLogged;
    private volatile boolean logConnection;

    public MonitoringPoolingDataSource(ObjectPool pool, long activeConnectionsLogInternval, int activeConnectionsLogThreshold, boolean logStackTrace) {
        super(pool);
        this.activeConnectionsLogThreshold = activeConnectionsLogThreshold;
        this.activeConnectionsLogInterval = activeConnectionsLogInternval;
        this.logStackTrace = logStackTrace;
    }

    public Connection getConnection() throws SQLException {
        try {
            Object conn = (Connection)this._pool.borrowObject();
            long now = System.currentTimeMillis();
            int numActive = this._pool.getNumActive();
            this.maxActiveSinceLastLogged = Math.max(this.maxActiveSinceLastLogged, numActive);
            if (this.logConnection || this.activeConnectionsLogInterval > 0L && now - this.lastLogged > this.activeConnectionsLogInterval && this.maxActiveSinceLastLogged > 1) {
                if (machineLog.isInfoEnabled()) {
                    machineLog.info((Object)String.format("Active database connections: current: %d, peak: %d.", numActive, this.maxActiveSinceLastLogged));
                }
                this.lastLogged = now;
                this.maxActiveSinceLastLogged = 0;
            }
            if (numActive > this.activeConnectionsLogThreshold) {
                if (!this.logConnection) {
                    this.logConnection = true;
                    notifyLog.warn((Object)String.format("Active database connections: %d > %d", numActive, this.activeConnectionsLogThreshold));
                }
            } else {
                this.logConnection = false;
            }
            if (conn != null) {
                conn = new PoolGuardConnectionWrapper((Connection)conn);
            }
            return conn;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new SQLNestedException("Cannot get a connection, pool error " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot get a connection, general error", (Throwable)e);
        }
    }

    static StackTraceElement[] getStackTrace() {
        Throwable th = new Throwable();
        th.fillInStackTrace();
        return th.getStackTrace();
    }

    static String tryGetServiceMethodName(StackTraceElement[] stackTrace) {
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().contains("$Proxy")) {
                return e.getMethodName();
            }
            ++n2;
        }
        return null;
    }

    static String traceToString(StackTraceElement[] trace) {
        StringBuilder builder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = trace;
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement te = stackTraceElementArray[n2];
            builder.append("\tat ");
            builder.append(te.toString());
            builder.append('\n');
            ++n2;
        }
        return builder.toString();
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        private Connection delegate;

        PoolGuardConnectionWrapper(Connection delegate) {
            super(delegate);
            this.delegate = delegate;
            this.log("Hand out database connection");
        }

        void log(String action) {
            if (MonitoringPoolingDataSource.this.logConnection && machineLog.isInfoEnabled()) {
                StackTraceElement[] stackTrace = MonitoringPoolingDataSource.getStackTrace();
                String serviceMethod = MonitoringPoolingDataSource.tryGetServiceMethodName(stackTrace);
                if (serviceMethod == null) {
                    if (MonitoringPoolingDataSource.this.logStackTrace) {
                        machineLog.info((Object)(String.valueOf(action) + ".\n" + MonitoringPoolingDataSource.traceToString(stackTrace)));
                    } else {
                        machineLog.info((Object)(String.valueOf(action) + "."));
                    }
                } else if (MonitoringPoolingDataSource.this.logStackTrace) {
                    machineLog.info((Object)(String.valueOf(action) + ", service method: " + serviceMethod + ".\n" + MonitoringPoolingDataSource.traceToString(stackTrace)));
                } else {
                    machineLog.info((Object)(String.valueOf(action) + ", service method: " + serviceMethod + "."));
                }
            }
        }

        protected void checkOpen() throws SQLException {
            if (this.delegate == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        public void close() throws SQLException {
            this.log("Return database connection");
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
                super.setDelegate(null);
            }
        }

        public boolean isClosed() throws SQLException {
            if (this.delegate == null) {
                return true;
            }
            return this.delegate.isClosed();
        }

        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this.delegate.clearWarnings();
        }

        public void commit() throws SQLException {
            this.checkOpen();
            this.delegate.commit();
        }

        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this.delegate.createStatement());
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
        }

        public boolean innermostDelegateEquals(Connection c) {
            Connection innerCon = super.getInnermostDelegate();
            if (innerCon == null) {
                return c == null;
            }
            return innerCon.equals(c);
        }

        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this.delegate.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this.delegate.getCatalog();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this.delegate.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this.delegate.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            this.checkOpen();
            return this.delegate.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this.delegate.getWarnings();
        }

        public int hashCode() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Connection conn = super.getInnermostDelegate();
            if (conn == null) {
                return false;
            }
            if (obj instanceof DelegatingConnection) {
                DelegatingConnection c = (DelegatingConnection)obj;
                return c.innermostDelegateEquals(conn);
            }
            return conn.equals(obj);
        }

        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this.delegate.isReadOnly();
        }

        public String nativeSQL(String sql) throws SQLException {
            this.checkOpen();
            return this.delegate.nativeSQL(sql);
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(sql));
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(sql));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }

        public void rollback() throws SQLException {
            this.checkOpen();
            this.delegate.rollback();
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.checkOpen();
            this.delegate.setAutoCommit(autoCommit);
        }

        public void setCatalog(String catalog) throws SQLException {
            this.checkOpen();
            this.delegate.setCatalog(catalog);
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.checkOpen();
            this.delegate.setReadOnly(readOnly);
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.checkOpen();
            this.delegate.setTransactionIsolation(level);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.checkOpen();
            this.delegate.setTypeMap(map);
        }

        public String toString() {
            if (this.delegate == null) {
                return "NULL";
            }
            return this.delegate.toString();
        }

        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this.delegate.getHoldability();
        }

        public void setHoldability(int holdability) throws SQLException {
            this.checkOpen();
            this.delegate.setHoldability(holdability);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint();
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint(name);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.releaseSavepoint(savepoint);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.rollback(savepoint);
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement((DelegatingConnection)this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(sql, columnIndexes));
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(sql, columnNames));
        }

        public Connection getDelegate() {
            if (MonitoringPoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        public Connection getInnermostDelegate() {
            if (MonitoringPoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

