/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.dbmigration.SimpleTableMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleDatabaseMetaData
extends AbstractHashable {
    private final String databaseVersion;
    private final List<SimpleTableMetaData> tables;
    private final Map<String, SimpleTableMetaData> tableDictonary;

    public SimpleDatabaseMetaData(String databaseVersion, List<SimpleTableMetaData> tables) {
        this.databaseVersion = databaseVersion;
        this.tableDictonary = new HashMap<String, SimpleTableMetaData>();
        for (SimpleTableMetaData simpleTableMetaData : tables) {
            this.tableDictonary.put(simpleTableMetaData.getTableName(), simpleTableMetaData);
        }
        this.tables = Collections.unmodifiableList(tables);
    }

    public final String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public final List<SimpleTableMetaData> getTables() {
        return this.tables;
    }

    public final SimpleTableMetaData tryToGetTableMetaData(String tableName) {
        return this.tableDictonary.get(tableName.toUpperCase());
    }
}

