/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.nio.charset.spi;

import de.schlichtherle.nio.charset.IBM437Charset;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class CharsetProvider
extends java.nio.charset.spi.CharsetProvider {
    private static final Map name2charset;
    private static final Collection charsets;

    public Charset charsetForName(String charset) {
        return (Charset)name2charset.get(CharsetProvider.lowerCase(charset));
    }

    private static final String lowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public Iterator charsets() {
        return charsets.iterator();
    }

    static {
        charsets = Collections.unmodifiableCollection(Arrays.asList(new IBM437Charset()));
        name2charset = new HashMap();
        Iterator i = charsets.iterator();
        while (i.hasNext()) {
            Charset cs = (Charset)i.next();
            name2charset.put(CharsetProvider.lowerCase(cs.name()), cs);
            Iterator<String> j = cs.aliases().iterator();
            while (j.hasNext()) {
                name2charset.put(CharsetProvider.lowerCase(j.next()), cs);
            }
        }
    }
}

