/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp.managed.TransactionContext;

public class TransactionRegistry {
    private final TransactionManager transactionManager;
    private final Map caches = new WeakHashMap();
    private final Map xaResources = new WeakHashMap();

    public TransactionRegistry(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public synchronized void registerConnection(Connection connection, XAResource xAResource) {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        if (xAResource == null) {
            throw new NullPointerException("xaResource is null");
        }
        this.xaResources.put(connection, xAResource);
    }

    public synchronized XAResource getXAResource(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        XAResource xAResource = (XAResource)this.xaResources.get(connection);
        if (xAResource == null) {
            throw new SQLException("Connection does not have a registered XAResource " + connection);
        }
        return xAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionContext getActiveTransactionContext() throws SQLException {
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return null;
            }
            int n = transaction.getStatus();
            if (n != 0 && n != 1) {
                return null;
            }
        }
        catch (SystemException systemException) {
            throw (SQLException)new SQLException("Unable to determine current transaction ").initCause(systemException);
        }
        TransactionRegistry transactionRegistry = this;
        synchronized (transactionRegistry) {
            TransactionContext transactionContext = (TransactionContext)this.caches.get(transaction);
            if (transactionContext == null) {
                transactionContext = new TransactionContext(this, transaction);
                this.caches.put(transaction, transactionContext);
            }
            return transactionContext;
        }
    }

    public synchronized void unregisterConnection(Connection connection) {
        this.xaResources.remove(connection);
    }
}

