/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics.dto;

import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.AnnotatedProtein;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Parameter;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Peptide;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.PeptideModification;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class Protein
extends AnnotatedProtein {
    private double probability;
    private double coverage;
    private int numberOfIndistinguishableProteins;
    private String uniqueStrippedPeptides;
    private String groupSiblingID;
    private int totalNumberOfPeptides;
    private String subsumingProtein;
    private String fractionOfCorrectPeptideIdentifications;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<AnnotatedProtein> indistinguishableProteins = new ArrayList<AnnotatedProtein>();
    private List<Peptide> peptides;

    @XmlAttribute(name="probability", required=true)
    public final double getProbability() {
        return this.probability;
    }

    public final void setProbability(double probability) {
        this.probability = probability;
    }

    @XmlAttribute(name="percent_coverage")
    public final double getCoverage() {
        return this.coverage;
    }

    public final void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    @XmlAttribute(name="n_indistinguishable_proteins", required=true)
    public final int getNumberOfIndistinguishableProteins() {
        return this.numberOfIndistinguishableProteins;
    }

    public final void setNumberOfIndistinguishableProteins(int numberOfIndistinguishableProteins) {
        this.numberOfIndistinguishableProteins = numberOfIndistinguishableProteins;
    }

    @XmlAttribute(name="unique_stripped_peptides")
    public final String getUniqueStrippedPeptides() {
        return this.uniqueStrippedPeptides;
    }

    public final void setUniqueStrippedPeptides(String uniqueStrippedPeptides) {
        this.uniqueStrippedPeptides = uniqueStrippedPeptides;
    }

    @XmlAttribute(name="group_sibling_id", required=true)
    public final String getGroupSiblingID() {
        return this.groupSiblingID;
    }

    public final void setGroupSiblingID(String groupSiblingID) {
        this.groupSiblingID = groupSiblingID;
    }

    @XmlAttribute(name="total_number_peptides")
    public final int getTotalNumberOfPeptides() {
        return this.totalNumberOfPeptides;
    }

    public final void setTotalNumberOfPeptides(int totalNumberOfPeptides) {
        this.totalNumberOfPeptides = totalNumberOfPeptides;
    }

    @XmlAttribute(name="subsuming_protein_entry")
    public final String getSubsumingProtein() {
        return this.subsumingProtein;
    }

    public final void setSubsumingProtein(String subsumingProtein) {
        this.subsumingProtein = subsumingProtein;
    }

    @XmlAttribute(name="pct_spectrum_ids")
    public final String getFractionOfCorrectPeptideIdentifications() {
        return this.fractionOfCorrectPeptideIdentifications;
    }

    public final void setFractionOfCorrectPeptideIdentifications(String fractionOfCorrectPeptideIdentifications) {
        this.fractionOfCorrectPeptideIdentifications = fractionOfCorrectPeptideIdentifications;
    }

    @XmlElement(name="parameter", namespace="http://regis-web.systemsbiology.net/protXML")
    public final List<Parameter> getParameters() {
        return this.parameters;
    }

    public final void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @XmlElement(name="indistinguishable_protein", namespace="http://regis-web.systemsbiology.net/protXML")
    public final List<AnnotatedProtein> getIndistinguishableProteins() {
        return this.indistinguishableProteins;
    }

    public final void setIndistinguishableProteins(List<AnnotatedProtein> indistinguishableProteins) {
        this.indistinguishableProteins = indistinguishableProteins;
    }

    @XmlElement(name="peptide", namespace="http://regis-web.systemsbiology.net/protXML")
    public final List<Peptide> getPeptides() {
        return this.peptides;
    }

    public final void setPeptides(List<Peptide> peptides) {
        this.peptides = peptides;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append("[probability=").append(this.probability);
        builder.append(", coverage=").append(this.coverage);
        builder.append(", indistinguishableProteins=").append(this.numberOfIndistinguishableProteins);
        if (this.uniqueStrippedPeptides != null) {
            builder.append(", uniqueStrippedPeptides=").append(this.uniqueStrippedPeptides);
        }
        builder.append(", groupSiblingID=").append(this.groupSiblingID);
        if (this.totalNumberOfPeptides > 0) {
            builder.append(", totalNumberOfPeptides=").append(this.totalNumberOfPeptides);
        }
        if (this.subsumingProtein != null) {
            builder.append(", subsumingProtein=").append(this.subsumingProtein);
        }
        if (this.fractionOfCorrectPeptideIdentifications != null) {
            builder.append(", fractionOfCorrectPeptideIdentifications=").append(this.fractionOfCorrectPeptideIdentifications);
        }
        builder.append("]");
        if (this.annotation != null) {
            builder.append("\n  ").append(this.annotation);
        }
        if (this.indistinguishableProteins != null && !this.indistinguishableProteins.isEmpty()) {
            builder.append("\n  indistinguishable proteins:");
            for (AnnotatedProtein protein : this.indistinguishableProteins) {
                builder.append("\n    ").append(protein);
            }
        }
        if (this.peptides != null && !this.peptides.isEmpty()) {
            builder.append("\n  peptides:");
            for (Peptide peptide : this.peptides) {
                builder.append("\n    ").append(peptide);
                List<PeptideModification> modifications = peptide.getModifications();
                if (modifications == null || modifications.isEmpty()) continue;
                for (PeptideModification modification : modifications) {
                    builder.append("\n      ").append(modification);
                }
            }
        }
        return builder.toString();
    }
}

