/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.transformers;

import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ch.systemsx.sybit.imageviewer.processors.LutProcessor;
import ij.ImagePlus;
import java.awt.image.BufferedImage;

public class IJImageTransformer
implements IImageTransformer {
    private ImageViewerParameters parameters;

    public ImageViewerParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ImageViewerParameters parameters) {
        this.parameters = parameters;
    }

    public IJImageTransformer(ImageViewerParameters parameters) {
        this.parameters = parameters;
    }

    public BufferedImage transform(BufferedImage image) {
        ImagePlus imagePlus = new ImagePlus("name", image);
        if (!this.parameters.getLutOperation().equals("")) {
            LutProcessor lutProcessor = new LutProcessor();
            lutProcessor.doOperation(this.parameters.getLutOperation(), this.parameters.getSlice(), imagePlus, imagePlus.getChannelProcessor().getColorModel());
        }
        imagePlus.getProcessor().snapshot();
        ImageUtil.modifyContrastBrightness(imagePlus, this.parameters);
        return imagePlus.getBufferedImage();
    }
}

